/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.feature;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.handlers.collections.CollectionsController;
import com.ibm.bi.search.indexing.solr.SolrQueryFactory;
import com.ibm.bi.search.indexing.solr.feature.Feature;
import com.ibm.bi.search.indexing.solr.feature.FeatureExtractor;
import com.ibm.bi.search.util.Ancestors;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsFeatureExt {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionsController solrController;
    private final SolrQueryFactory queryFactory = new SolrQueryFactory();

    public SmartsFeatureExt() {
        this(new CollectionsController());
    }

    protected SmartsFeatureExt(CollectionsController solrController) {
        this.solrController = solrController;
    }

    public void indexSmartsModuleFeatures(JsonArray documents) throws IOException {
        if (!documents.isEmpty()) {
            this.removeSmartsModuleFeatures(SmartsFeatureExt.getDocumentIds(documents));
        }
        ArrayList<Feature> featureDocuments = new ArrayList<Feature>();
        for (Object o : documents) {
            JsonObject document = (JsonObject)o;
            FeatureExtractor extractor = new FeatureExtractor(SmartsFeatureExt.getSmartsModule(document), SmartsFeatureExt.getDocumentTenantID(document), document.getString(FieldNames.OWNER.toString()), SmartsFeatureExt.getParentIDFromAncestors(document), document.getString(FieldNames.VIRTUAL_PARENT.toString()), document.getString(FieldNames.ID.toString()));
            featureDocuments.addAll(extractor.extractFeatures());
        }
        this.processFeaturesToDocuments(featureDocuments);
    }

    private static SmartsModule getSmartsModule(JsonObject jsonSource) throws IOException {
        String smartsData = jsonSource.getString(FieldNames.CONTENT.toString());
        if (!smartsData.startsWith("{")) {
            smartsData = SmartsFeatureExt.decodeJsonData(smartsData);
        }
        return (SmartsModule)JAXBHelper.unmarshalFromJSON(SmartsModule.class, (String)smartsData);
    }

    private static String decodeJsonData(String jsonData) throws IOException {
        byte[] base64 = Base64.getDecoder().decode(jsonData);
        ByteArrayInputStream bis = new ByteArrayInputStream(base64);
        GZIPInputStream gzipIS = new GZIPInputStream(bis);
        return IOUtils.toString((InputStream)gzipIS, (Charset)StandardCharsets.UTF_8);
    }

    private static String getDocumentTenantID(JsonObject document) {
        if (StringUtils.isEmpty((String)document.getString(FieldNames.TENANT_ID.toString()))) {
            return "publictenant";
        }
        return document.getString(FieldNames.TENANT_ID.toString());
    }

    private static String getParentIDFromAncestors(JsonObject document) {
        Object parentID = null;
        String ancestorsPath = Ancestors.getAncestorPath(document);
        Object[] ancestorsArray = StringUtils.split((String)ancestorsPath, (char)'/');
        if (ArrayUtils.isNotEmpty((Object[])ancestorsArray)) {
            parentID = ancestorsArray[ancestorsArray.length - 1];
        }
        return parentID;
    }

    private void processFeaturesToDocuments(List<Feature> features) {
        JsonArray featureDocuments = new JsonArray();
        for (Feature feature : features) {
            JsonObject featureJson = this.featureToJson(feature);
            if (featureJson == null) continue;
            featureDocuments.add((Object)featureJson);
        }
        this.solrController.addDocuments(IndexNames.SMARTS_FEATURE.toString(), featureDocuments);
    }

    protected JsonObject featureToJson(Feature feature) {
        JsonObject featureJson = null;
        try {
            featureJson = feature.toJsonObject();
        }
        catch (Exception ex) {
            LOG.warn("Invalid Feature with smartsModule ID {} has been skipped.", (Object)feature.getSmartsModulePartRef());
        }
        return featureJson;
    }

    public void removeSmartsModuleFeatures(List<String> ids) {
        String deleteQuery = this.queryFactory.createDeleteByQuery(FieldNames.SMARTS_MODULE_PART_REF.toString(), ids);
        this.solrController.deleteDocumentsByQuery(IndexNames.SMARTS_FEATURE.toString(), deleteQuery);
    }

    private static List<String> getDocumentIds(JsonArray documents) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Object o : documents) {
            JsonObject document = (JsonObject)o;
            ids.add(document.getString(FieldNames.ID.toString()));
        }
        return ids;
    }
}

