/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.policies;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.handlers.common.QueryResult;
import com.ibm.bi.search.indexing.solr.SolrHandlerFactory;
import com.ibm.bi.search.indexing.solr.SolrQueryFactory;
import com.ibm.bi.search.indexing.solr.policies.PoliciesIndex;
import com.ibm.bi.search.indexing.solr.policies.SearchPolicyObject;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;

public class CloudPoliciesIndex
implements PoliciesIndex {
    private final SolrHandlerFactory solrFactory;
    private final SolrQueryFactory queryFactory;

    public CloudPoliciesIndex() {
        this(new SolrHandlerFactory());
    }

    protected CloudPoliciesIndex(SolrHandlerFactory solrFactory) {
        this.solrFactory = solrFactory;
        this.queryFactory = new SolrQueryFactory();
    }

    @Override
    public void savePolicy(String id, SearchPolicyObject policyObject) {
        this.solrFactory.createSolrHandler().updateDocument(IndexNames.POLICIES.toString(), policyObject.toJson());
    }

    @Override
    public void deletePolicy(String id) {
        this.solrFactory.createSolrHandler().deleteDocument(IndexNames.POLICIES.toString(), id);
    }

    @Override
    public SearchPolicyObject getPolicy(String id) {
        QueryResult result = this.solrFactory.createSolrHandler().query(IndexNames.POLICIES.toString(), this.queryFactory.createQueryByIds(Arrays.asList(id)));
        return CloudPoliciesIndex.buildPolicyObject(CloudPoliciesIndex.extractDocumentFromResult(result));
    }

    private static JsonObject extractDocumentFromResult(QueryResult result) {
        JsonArray results = result.toJSON().getArray("results");
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            return results.getObject(0);
        }
        return null;
    }

    private static SearchPolicyObject buildPolicyObject(JsonObject document) {
        return document != null ? new SearchPolicyObject(document) : null;
    }

    @Override
    public boolean hasPolicy(String id) {
        return this.getPolicy(id) != null;
    }

    @Override
    public void deleteStorage() {
    }
}

