/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.policies;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import com.ibm.bi.search.async.StorageCleaner;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.indexing.solr.policies.PoliciesIndex;
import com.ibm.bi.search.indexing.solr.policies.SearchPolicyObject;
import com.ibm.bi.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDiskPoliciesIndex
implements PoliciesIndex {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int FOLDER_PREFIX_LENGTH = 3;
    private static final int FOLDER_PREFIX_LENGTH_PLUS_SLASHES = 5;
    private static final int MAX_FILENAME_LENGTH = 255;
    private static final int MAX_PATH_LENGTH = 260;
    private static final String DEFAULT_SUBFOLDER = "default";
    private static final String POLICIES = IndexNames.POLICIES.toString();
    private static final String STORAGE = "storage";
    private static final HashSet<Character> INVALID_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\"'), Character.valueOf('|'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('\\')));
    private final String storageFolder;
    private final StorageCleaner storageCleaner;

    public OnDiskPoliciesIndex() {
        this(new StorageCleaner());
    }

    protected OnDiskPoliciesIndex(StorageCleaner storageCleaner) {
        this.storageCleaner = storageCleaner;
        this.storageFolder = this.buildStorageFolderPath();
        LOG.info("Policies storage folder: {}", (Object)this.storageFolder);
    }

    private String buildStorageFolderPath() {
        Path storagePath = Paths.get(SearchConfig.getCollectionsDirectory(), POLICIES, STORAGE);
        return new File(storagePath.toString()).getAbsolutePath();
    }

    protected String getStorageFolder() {
        return this.storageFolder;
    }

    @Override
    public void savePolicy(String id, SearchPolicyObject policyObject) {
        try {
            Files.write(this.getOrCreatePath(id), OnDiskPoliciesIndex.compress(policyObject.toString()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw SearchException.wrap((Exception)e, "Failed to write object to policies storage, id: {}", id);
        }
    }

    private Path getOrCreatePath(String id) throws IOException {
        String folder = this.buildPath(id);
        FileUtils.forceMkdir((File)new File(folder));
        return this.getPath(folder, id);
    }

    private String buildPath(String id) {
        String subfolder = StringUtils.substring((String)id, (int)0, (int)3);
        if (this.hasInvalidCharacter(subfolder)) {
            subfolder = DEFAULT_SUBFOLDER;
        }
        return Paths.get(this.storageFolder, subfolder).toString();
    }

    private Path getPath(String folder, String id) {
        String filename = this.compressIfNeeded(id);
        return Paths.get(folder, filename);
    }

    private String compressIfNeeded(String id) {
        if (this.isTooLong(id) || this.hasInvalidCharacter(id)) {
            return this.generateUniqueHashcode(id);
        }
        return id;
    }

    private boolean isTooLong(String id) {
        return this.isFilenameTooLong(id) || this.isPathTooLong(id);
    }

    private boolean hasInvalidCharacter(String id) {
        for (char letter : id.toCharArray()) {
            if (!INVALID_CHARS.contains(Character.valueOf(letter))) continue;
            return true;
        }
        return false;
    }

    private boolean isFilenameTooLong(String id) {
        return id.length() > 255;
    }

    private boolean isPathTooLong(String id) {
        return this.storageFolder.length() + 5 + id.length() > 260;
    }

    private String generateUniqueHashcode(String id) {
        int split = id.length() / 2;
        String left = id.substring(0, split);
        String right = id.substring(split);
        return "" + id.hashCode() + '.' + left.hashCode() + '.' + right.hashCode();
    }

    @Override
    public void deletePolicy(String id) {
        try {
            Files.deleteIfExists(this.getPath(id));
        }
        catch (IOException e) {
            throw SearchException.wrap((Exception)e, "Failed to delete object from policies storage, id: {}", id);
        }
    }

    protected Path getPath(String id) {
        String folder = this.buildPath(id);
        return this.getPath(folder, id);
    }

    @Override
    public boolean hasPolicy(String id) {
        return Files.exists(this.getPath(id), new LinkOption[0]);
    }

    @Override
    public SearchPolicyObject getPolicy(String id) {
        byte[] compressedPolicy;
        try {
            compressedPolicy = Files.readAllBytes(this.getPath(id));
        }
        catch (IOException e) {
            LOG.trace("Policies object not found, id: {}", (Object)id);
            return null;
        }
        if (ArrayUtils.isEmpty((byte[])compressedPolicy)) {
            LOG.warn("Policy object was found but it's empty, id: {}", (Object)id);
            return null;
        }
        return this.parsePolicyObject(id, compressedPolicy);
    }

    private SearchPolicyObject parsePolicyObject(String id, byte[] compressedPolicy) {
        try {
            JsonObject doc = this.parseJsonObject(OnDiskPoliciesIndex.decompress(compressedPolicy));
            return this.buildPolicyObject(id, doc);
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "Failed to parse policy JSON, id: {}", id);
        }
    }

    private JsonObject parseJsonObject(String s) throws IOException {
        return (JsonObject)new JsonParser().parse((Reader)new StringReader(s));
    }

    private SearchPolicyObject buildPolicyObject(String id, JsonObject document) {
        this.failIfWrongDocumentWasRetrieved(document, id);
        return new SearchPolicyObject(document);
    }

    private void failIfWrongDocumentWasRetrieved(JsonObject document, String expectedId) {
        String id = document.getString(FieldNames.ID.toString());
        if (!StringUtils.equals((String)id, (String)expectedId)) {
            LOG.warn("Policy object ID mismatch detected. Retrieved: {}, expected: {}", (Object)id, (Object)expectedId);
            this.deletePolicy(expectedId);
            throw new SearchException(SearchMessageKeys.INTERNAL_ERROR, "Policy object [" + expectedId + "] deleted because it had the wrong id: " + id);
        }
    }

    private static byte[] compress(String policy) throws IOException {
        if (StringUtils.isBlank((String)policy)) {
            throw SearchException.wrap((Exception)new IllegalArgumentException(), "policy cannot be blank", new Object[0]);
        }
        ByteArrayOutputStream policyStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(policyStream);){
            gzip.write(policy.getBytes(StandardCharsets.UTF_8));
        }
        return policyStream.toByteArray();
    }

    private static String decompress(byte[] policy) throws IOException {
        try (GZIPInputStream policyStream = new GZIPInputStream(new ByteArrayInputStream(policy));){
            String line;
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)policyStream, StandardCharsets.UTF_8));
            StringBuilder decompressed = new StringBuilder();
            while ((line = bf.readLine()) != null) {
                decompressed.append(line);
            }
            String string = decompressed.toString();
            return string;
        }
    }

    @Override
    public void deleteStorage() {
        LOG.debug("Deleting local storage: [{}]", (Object)this.storageFolder);
        this.storageCleaner.deleteLater(this.storageFolder);
    }
}

