/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.policies;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.util.RequestContext;
import com.ibm.bi.search.util.SearchConfig;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionCheck {
    private static final String CM_V1_PATH = "cm/1.0/";
    private static final int CM_PATH_SUBLENGTH = 7;
    private static final String CM_BATCH_ID_CHECK_PATH = "accessible_objects";
    private static final String COMMA = ",";
    private static final String ID_FIELD = FieldNames.ID.toString();
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private RESTClient restClient;
    private static String cmBaseUrl = PermissionCheck.buildCMBaseURL();

    public PermissionCheck() {
        this(RESTClientFactory.getInstance().getClient(RequestContext.getHttpRequest()));
    }

    protected PermissionCheck(RESTClient client) {
        this.restClient = client;
    }

    private static String buildCMBaseURL() {
        String cmUrl = SearchConfig.getCMUrl();
        return cmUrl.substring(0, cmUrl.length() - 7) + CM_V1_PATH;
    }

    public List<String> getValidBatch(JsonArray hits) {
        if (!SearchConfig.isPostFilterPermissionCheckEnabled()) {
            return Collections.emptyList();
        }
        List<String> ids = this.extractIdsFromHits(hits);
        Identity identity = RequestContext.getCurrentIdentity();
        if (identity != null && identity.isSystemAdmin()) {
            LOG.trace("Skipping post filter check because user is System Admin.");
            return ids;
        }
        try {
            return this.batchGet(String.join((CharSequence)COMMA, ids));
        }
        catch (Exception e) {
            LOG.debug("Failed to check permissions: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<String> extractIdsFromHits(JsonArray hits) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Object o : hits) {
            JsonObject hit = (JsonObject)o;
            ids.add(hit.getString(ID_FIELD));
        }
        return ids;
    }

    private List<String> batchGet(String ids) throws IOException {
        String reqUrl = this.buildCMBatchUrl(ids);
        return this.getResponseIds(this.restClient.getResourceStream(reqUrl, "text/plain"));
    }

    private String buildCMBatchUrl(String ids) {
        return cmBaseUrl + CM_BATCH_ID_CHECK_PATH + "?ids=" + ids;
    }

    private List<String> getResponseIds(InputStream response) throws IOException {
        ArrayList<String> valid = new ArrayList<String>();
        if (response != null) {
            StringTokenizer st = new StringTokenizer(IOUtils.toString((InputStream)response, (Charset)StandardCharsets.UTF_8), COMMA);
            while (st.hasMoreTokens()) {
                valid.add(st.nextToken());
            }
        }
        return valid;
    }

    protected static void setCMBaseUrl(String s) {
        cmBaseUrl = s;
    }
}

