/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.policies;

import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.indexing.solr.policies.CloudPoliciesIndex;
import com.ibm.bi.search.indexing.solr.policies.OnDiskPoliciesIndex;
import com.ibm.bi.search.indexing.solr.policies.PoliciesIndex;
import com.ibm.bi.search.indexing.solr.policies.SearchPolicyObject;
import com.ibm.bi.search.util.SearchConfig;
import java.lang.invoke.MethodHandles;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoliciesCache {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final LoadingCache<String, SearchPolicyObject> caffeineCache;
    private final PoliciesIndex policiesIndex;

    public PoliciesCache() {
        this(PoliciesCache.isSolrEmbedded() ? new OnDiskPoliciesIndex() : new CloudPoliciesIndex());
    }

    private static boolean isSolrEmbedded() {
        return StringUtils.isEmpty((CharSequence)SearchConfig.getSolrServerURL());
    }

    protected PoliciesCache(PoliciesIndex policiesIndex) {
        this.policiesIndex = policiesIndex;
        this.caffeineCache = this.initializeCache();
    }

    private LoadingCache<String, SearchPolicyObject> initializeCache() {
        int maximumSize = SearchConfig.getPoliciesCacheMaxSize();
        LOG.info("Initializing policies cache. Maximum size: {} items.", (Object)maximumSize);
        return Caffeine.newBuilder().maximumSize((long)maximumSize).writer((CacheWriter)new CacheWriter<String, SearchPolicyObject>(){

            public void write(String key, SearchPolicyObject object) {
                PoliciesCache.this.writeEntry(key, object);
            }

            public void delete(String key, SearchPolicyObject object, RemovalCause cause) {
                PoliciesCache.this.deleteEntry(key, object, cause);
            }
        }).build(this::buildCacheEntry);
    }

    private void writeEntry(String key, SearchPolicyObject object) {
        LOG.trace("Writing object with id {} to the policies index.", (Object)key);
        this.policiesIndex.savePolicy(key, object);
    }

    private void deleteEntry(String key, SearchPolicyObject object, RemovalCause cause) {
        LOG.trace("Deleting object with id {} from the cache, for reason: {}.", (Object)object.getId(), (Object)cause);
        if (this.shouldAlsoDeleteFromIndex(cause)) {
            LOG.trace("Deleting object with id {} from the policies index.", (Object)key);
            this.policiesIndex.deletePolicy(key);
        }
    }

    private boolean shouldAlsoDeleteFromIndex(RemovalCause cause) {
        return cause == RemovalCause.EXPLICIT;
    }

    private SearchPolicyObject buildCacheEntry(String key) {
        LOG.trace("Building cache entry for object with id {}.", (Object)key);
        return this.policiesIndex.getPolicy(key);
    }

    public void addDocument(JsonObject document) {
        String cacheId = document.getString(FieldNames.ID.toString());
        this.caffeineCache.put((Object)cacheId, (Object)new SearchPolicyObject(document));
    }

    public void deleteDocument(String id) {
        this.caffeineCache.invalidate((Object)id);
    }

    public SearchPolicyObject retrieve(String id) {
        return (SearchPolicyObject)this.caffeineCache.get((Object)id);
    }

    long getEstimatedSize() {
        return this.caffeineCache.estimatedSize();
    }

    public boolean exists(String id) {
        return this.policiesIndex.hasPolicy(id);
    }

    PoliciesIndex getPoliciesIndex() {
        return this.policiesIndex;
    }

    public void deleteStorage() {
        this.policiesIndex.deleteStorage();
    }
}

