/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.policies;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.indexing.solr.CollectionCreator;
import com.ibm.bi.search.indexing.solr.policies.PoliciesCache;
import com.ibm.bi.search.indexing.solr.policies.PoliciesCacheFactory;

public class PoliciesController {
    private final PoliciesCache policiesCache;
    private final CollectionCreator collectionCreator;

    public PoliciesController() {
        this(new PoliciesCacheFactory(), new CollectionCreator());
    }

    protected PoliciesController(PoliciesCacheFactory policiesFactory, CollectionCreator creator) {
        this.policiesCache = policiesFactory.getPoliciesCache();
        this.collectionCreator = creator;
    }

    public void createIndex() {
        this.collectionCreator.createPoliciesCollection();
    }

    public void addDocuments(JsonArray documents) {
        if (documents != null) {
            documents.forEach(doc -> this.addDocument((JsonObject)doc));
        }
    }

    private void addDocument(JsonObject document) {
        this.policiesCache.addDocument(document);
    }

    public void deleteDocuments(JsonArray documentIds) {
        if (documentIds != null) {
            documentIds.forEach(id -> this.deleteDocument(id.toString()));
        }
    }

    public void deleteDocument(String documentId) {
        this.policiesCache.deleteDocument(documentId);
    }

    public void updatePermission(JsonObject document) {
        this.deleteDocument(document.getString(FieldNames.ID.toString()));
        this.addDocument(document);
    }
}

