/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.policies;

import com.ibm.bi.search.util.SearchConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public enum PolicyType {
    READ,
    WRITE,
    EXECUTE,
    SET_POLICY("setPolicy"),
    TRAVERSE;

    private String name;

    private PolicyType() {
        this.name = this.name().toLowerCase(Locale.ENGLISH);
    }

    private PolicyType(String name) {
        this.name = name;
    }

    public static List<PolicyType> getAcceptedPolicyTypes() {
        String[] navFilters;
        ArrayList<PolicyType> acceptedPolicies = new ArrayList<PolicyType>();
        for (String navFilter : navFilters = SearchConfig.getNavFilter().split(",")) {
            PolicyType policyType = PolicyType.getPolicyType(navFilter);
            if (policyType == null) continue;
            acceptedPolicies.add(policyType);
        }
        return acceptedPolicies;
    }

    private static PolicyType getPolicyType(String policyName) {
        if (policyName.equals(PolicyType.READ.name)) {
            return READ;
        }
        if (policyName.equals(PolicyType.WRITE.name)) {
            return WRITE;
        }
        if (policyName.equals(PolicyType.EXECUTE.name)) {
            return EXECUTE;
        }
        if (policyName.equals(PolicyType.SET_POLICY.name)) {
            return SET_POLICY;
        }
        if (policyName.equals(PolicyType.TRAVERSE.name)) {
            return TRAVERSE;
        }
        return null;
    }
}

