/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.indexing.solr.policies;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.util.Ancestors;
import com.ibm.bi.search.util.SearchUtils;
import java.util.List;

public class SearchPolicyObject {
    private static final JsonArray ALL_GRANULAR_PERMISSIONS = new JsonArray(new Object[]{FieldNames.READ.toString(), FieldNames.WRITE.toString(), FieldNames.EXECUTE.toString(), FieldNames.SETPOLICY.toString(), FieldNames.TRAVERSE.toString()});
    private String id;
    private String tenantID;
    private String userID;
    private String owner;
    private String disabled;
    private String hidden;
    private String classType;
    private String ancestorPath;
    private JsonObject grant;
    private JsonObject deny;

    public SearchPolicyObject() {
    }

    public SearchPolicyObject(JsonObject doc) {
        this.setId(doc.getString(FieldNames.ID.toString()));
        this.setTenantID(doc.getString(FieldNames.TENANT_ID.toString()));
        this.setUserID(doc.getString(FieldNames.USER_ID.toString()));
        this.setOwner(doc.getString(FieldNames.OWNER.toString()));
        this.setDisabled(doc.getString(FieldNames.DISABLED.toString()));
        this.setHidden(doc.getString(FieldNames.HIDDEN.toString()));
        this.setAncestorPath(Ancestors.getAncestorPath(doc));
        this.setClassType(doc.getString(FieldNames.TYPE.toString()));
        this.setPermissions(doc);
    }

    private void setPermissions(JsonObject doc) {
        JsonObject permissions = doc.getObject(FieldNames.PERMISSIONS.toString());
        if (permissions != null) {
            this.parsePermissionsFromCM(permissions);
        } else {
            this.reconstructPermissionFromFlattenedPolicies(doc);
        }
    }

    private void parsePermissionsFromCM(JsonObject permissions) {
        this.setGrantObject(this.getPermissions(permissions.get(FieldNames.GRANT.toString())));
        this.setDenyObject(this.getPermissions(permissions.get(FieldNames.DENY.toString())));
    }

    private void reconstructPermissionFromFlattenedPolicies(JsonObject doc) {
        this.setGrantObject(this.createGrantObject(doc));
        this.setDenyObject(this.createDenyObject(doc));
    }

    private JsonObject createGrantObject(JsonObject document) {
        JsonObject grantObj = new JsonObject();
        if (document.containsKey((Object)FieldNames.READ_GRANT.toString())) {
            grantObj.put(FieldNames.READ.toString(), document.get(FieldNames.READ_GRANT.toString()));
        }
        if (document.containsKey((Object)FieldNames.WRITE_GRANT.toString())) {
            grantObj.put(FieldNames.WRITE.toString(), document.get(FieldNames.WRITE_GRANT.toString()));
        }
        if (document.containsKey((Object)FieldNames.EXECUTE_GRANT.toString())) {
            grantObj.put(FieldNames.EXECUTE.toString(), document.get(FieldNames.EXECUTE_GRANT.toString()));
        }
        if (document.containsKey((Object)FieldNames.SETPOLICY_GRANT.toString())) {
            grantObj.put(FieldNames.SETPOLICY.toString(), document.get(FieldNames.SETPOLICY_GRANT.toString()));
        }
        if (document.containsKey((Object)FieldNames.TRAVERSE_GRANT.toString())) {
            grantObj.put(FieldNames.TRAVERSE.toString(), document.get(FieldNames.TRAVERSE_GRANT.toString()));
        }
        return grantObj.isEmpty() ? null : grantObj;
    }

    private JsonObject createDenyObject(JsonObject document) {
        JsonObject denyObj = new JsonObject();
        if (document.containsKey((Object)FieldNames.READ_DENY.toString())) {
            denyObj.put(FieldNames.READ.toString(), document.get(FieldNames.READ_DENY.toString()));
        }
        if (document.containsKey((Object)FieldNames.WRITE_DENY.toString())) {
            denyObj.put(FieldNames.WRITE.toString(), document.get(FieldNames.WRITE_DENY.toString()));
        }
        if (document.containsKey((Object)FieldNames.EXECUTE_DENY.toString())) {
            denyObj.put(FieldNames.EXECUTE.toString(), document.get(FieldNames.EXECUTE_DENY.toString()));
        }
        if (document.containsKey((Object)FieldNames.SETPOLICY_DENY.toString())) {
            denyObj.put(FieldNames.SETPOLICY.toString(), document.get(FieldNames.SETPOLICY_DENY.toString()));
        }
        if (document.containsKey((Object)FieldNames.TRAVERSE_DENY.toString())) {
            denyObj.put(FieldNames.TRAVERSE.toString(), document.get(FieldNames.TRAVERSE_DENY.toString()));
        }
        return denyObj.isEmpty() ? null : denyObj;
    }

    private JsonObject getPermissions(Object permissions) {
        if (permissions instanceof JsonObject) {
            return (JsonObject)permissions;
        }
        if (permissions instanceof JsonArray) {
            return this.createFullPermissions((JsonArray)permissions);
        }
        return new JsonObject();
    }

    private JsonObject createFullPermissions(JsonArray permissions) {
        JsonObject json = new JsonObject();
        json.set(FieldNames.READ.toString(), (Object)permissions);
        json.set(FieldNames.WRITE.toString(), (Object)permissions);
        json.set(FieldNames.EXECUTE.toString(), (Object)permissions);
        json.set(FieldNames.SETPOLICY.toString(), (Object)permissions);
        json.set(FieldNames.TRAVERSE.toString(), (Object)permissions);
        return json;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getDisabled() {
        return this.disabled;
    }

    public boolean isDisabled() {
        return Boolean.valueOf(this.disabled);
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    public String getHidden() {
        return this.hidden;
    }

    public boolean isHidden() {
        return Boolean.valueOf(this.hidden);
    }

    public void setHidden(String hidden) {
        this.hidden = hidden;
    }

    public String getAncestorPath() {
        return this.ancestorPath;
    }

    public void setAncestorPath(String ancestorPath) {
        this.ancestorPath = ancestorPath;
    }

    public JsonObject getGrantObject() {
        return this.grant;
    }

    public void setGrantObject(JsonObject grantObj) {
        this.grant = grantObj;
    }

    public JsonObject getDenyObject() {
        return this.deny;
    }

    public void setDenyObject(JsonObject denyObj) {
        this.deny = denyObj;
    }

    public JsonArray getReadGrant() {
        return this.getGrantPermission(FieldNames.READ.toString());
    }

    public JsonArray getReadDeny() {
        return this.getDenyPermission(FieldNames.READ.toString());
    }

    public JsonArray getWriteGrant() {
        return this.getGrantPermission(FieldNames.WRITE.toString());
    }

    public JsonArray getWriteDeny() {
        return this.getDenyPermission(FieldNames.WRITE.toString());
    }

    public JsonArray getExecuteGrant() {
        return this.getGrantPermission(FieldNames.EXECUTE.toString());
    }

    public JsonArray getExecuteDeny() {
        return this.getDenyPermission(FieldNames.EXECUTE.toString());
    }

    public JsonArray getSetPolicyGrant() {
        return this.getGrantPermission(FieldNames.SETPOLICY.toString());
    }

    public JsonArray getSetPolicyDeny() {
        return this.getDenyPermission(FieldNames.SETPOLICY.toString());
    }

    public JsonArray getTraverseGrant() {
        return this.getGrantPermission(FieldNames.TRAVERSE.toString());
    }

    public JsonArray getTraverseDeny() {
        return this.getDenyPermission(FieldNames.TRAVERSE.toString());
    }

    private JsonArray getGrantPermission(String type) {
        if (this.grant == null) {
            return new JsonArray();
        }
        return this.grant.getArray(type);
    }

    private JsonArray getDenyPermission(String type) {
        if (this.deny == null) {
            return new JsonArray();
        }
        return this.deny.getArray(type);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put(FieldNames.ID.toString(), (Object)this.getId());
        json.put(FieldNames.TENANT_ID.toString(), (Object)this.getTenantID());
        json.put(FieldNames.USER_ID.toString(), (Object)this.getUserID());
        json.put(FieldNames.OWNER.toString(), (Object)this.getOwner());
        json.put(FieldNames.DISABLED.toString(), (Object)this.getDisabled());
        json.put(FieldNames.HIDDEN.toString(), (Object)this.getHidden());
        json.put(FieldNames.TYPE.toString(), (Object)this.getClassType());
        json.put(FieldNames.ANCESTORS.toString(), (Object)this.getAncestorPath());
        json.put(FieldNames.READ_GRANT.toString(), (Object)this.getReadGrant());
        json.put(FieldNames.READ_DENY.toString(), (Object)this.getReadDeny());
        json.put(FieldNames.WRITE_GRANT.toString(), (Object)this.getWriteGrant());
        json.put(FieldNames.WRITE_DENY.toString(), (Object)this.getWriteDeny());
        json.put(FieldNames.EXECUTE_GRANT.toString(), (Object)this.getExecuteGrant());
        json.put(FieldNames.EXECUTE_DENY.toString(), (Object)this.getExecuteDeny());
        json.put(FieldNames.SETPOLICY_GRANT.toString(), (Object)this.getSetPolicyGrant());
        json.put(FieldNames.SETPOLICY_DENY.toString(), (Object)this.getSetPolicyDeny());
        json.put(FieldNames.TRAVERSE_GRANT.toString(), (Object)this.getTraverseGrant());
        json.put(FieldNames.TRAVERSE_DENY.toString(), (Object)this.getTraverseDeny());
        return json;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public JsonArray getGrantedPermissions(Identity identity) {
        JsonArray grantedPermissions = new JsonArray();
        if (identity != null) {
            List<String> camIDs = identity.getCAMIds();
            if (identity.isSystemAdmin() || this.isDocumentOwner(identity)) {
                return ALL_GRANULAR_PERMISSIONS;
            }
            if (SearchUtils.listContainsAny(this.getReadGrant(), camIDs)) {
                grantedPermissions.add((Object)FieldNames.READ.toString());
            }
            if (SearchUtils.listContainsAny(this.getWriteGrant(), camIDs)) {
                grantedPermissions.add((Object)FieldNames.WRITE.toString());
            }
            if (SearchUtils.listContainsAny(this.getExecuteGrant(), camIDs)) {
                grantedPermissions.add((Object)FieldNames.EXECUTE.toString());
            }
            if (SearchUtils.listContainsAny(this.getSetPolicyGrant(), camIDs)) {
                grantedPermissions.add((Object)FieldNames.SETPOLICY.toString());
            }
            if (SearchUtils.listContainsAny(this.getTraverseGrant(), camIDs)) {
                grantedPermissions.add((Object)FieldNames.TRAVERSE.toString());
            }
        }
        return grantedPermissions;
    }

    private boolean isDocumentOwner(Identity identity) {
        String docOwner = this.getOwner();
        return docOwner != null && docOwner.equalsIgnoreCase(identity.getUserStoreID());
    }
}

