/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.language;

import com.ibm.bi.search.language.ContentLocaleMap;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContentLocaleMap
implements ContentLocaleMap {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String WILDCARD_REGEX = "(.*)";
    protected final Map<String, String> localeMapping = new HashMap<String, String>();
    private final Map<String, String> mappedLocalesCache = new ConcurrentHashMap<String, String>();

    @Override
    public Map<String, String> getLocaleMapping() {
        return this.localeMapping;
    }

    @Override
    public String getMappedLocale(String locale) {
        if (this.mappingContainsExactMatch(locale)) {
            return this.localeMapping.get(locale);
        }
        return this.getMappedLocaleUsingWildcard(locale);
    }

    private boolean mappingContainsExactMatch(String locale) {
        return this.localeMapping.containsKey(locale);
    }

    private String getMappedLocaleUsingWildcard(String locale) {
        String mappedLocale = this.mappedLocalesCache.get(locale);
        if (mappedLocale != null) {
            return mappedLocale;
        }
        mappedLocale = this.findMappedLocaleUsingWildcard(locale);
        this.mappedLocalesCache.put(locale, mappedLocale.intern());
        LOG.debug("Saving mapped locale [{}:{}]. Cache has {} entries now.", new Object[]{locale, mappedLocale, this.mappedLocalesCache.size()});
        return mappedLocale;
    }

    private String findMappedLocaleUsingWildcard(String locale) {
        for (Map.Entry<String, String> entry : this.localeMapping.entrySet()) {
            if (!locale.matches(AbstractContentLocaleMap.convertKeyToRegex(entry.getKey()))) continue;
            return entry.getValue();
        }
        return locale;
    }

    private static String convertKeyToRegex(String key) {
        return key.replace("*", WILDCARD_REGEX);
    }
}

