/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.language;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.language.AbstractContentLocaleMap;
import com.ibm.bi.search.util.BIConfig;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ConfigurationContentLocaleMap
extends AbstractContentLocaleMap {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String CONTENT_LOCALE_MAP_KEY = "contentLocaleMap";
    private static final String NODE_SELECTOR = "/value/localeMap";
    private static final String NODE_ATTRIBUTE_KEY = "@key";
    private static final String NODE_ATTRIBUTE_VALUE = "@value";
    private final BIConfig biConfig;

    public ConfigurationContentLocaleMap() {
        this(new BIConfig());
    }

    protected ConfigurationContentLocaleMap(BIConfig biConfig) {
        this.biConfig = biConfig;
        this.initialize();
    }

    @Override
    public void initialize() {
        LOG.debug("Waiting for BI configuration to be ready.");
        this.biConfig.callWhenReady(this::buildContentLocaleMap);
    }

    private void buildContentLocaleMap(ConfigurationPropertyFactory configFactory) {
        String localeMap = configFactory.getStringProperty(CONTENT_LOCALE_MAP_KEY).get();
        LOG.debug("{}: {}", (Object)CONTENT_LOCALE_MAP_KEY, (Object)localeMap);
        try {
            SAXReader reader = this.createSaxReader();
            Document contentMap = reader.read(ConfigurationContentLocaleMap.getLocaleMapAsInputStream(localeMap));
            List nodes = contentMap.selectNodes(NODE_SELECTOR);
            for (Node node : nodes) {
                this.localeMapping.put(node.valueOf(NODE_ATTRIBUTE_KEY), node.valueOf(NODE_ATTRIBUTE_VALUE));
            }
        }
        catch (Exception e) {
            throw new SearchException(SearchMessageKeys.INVALID_DATA_FORMAT, e);
        }
    }

    private SAXReader createSaxReader() throws SAXException {
        SAXReader reader = new SAXReader();
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return reader;
    }

    private static InputStream getLocaleMapAsInputStream(String localeMap) {
        return new ByteArrayInputStream(localeMap.getBytes(StandardCharsets.UTF_8));
    }
}

