/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.language;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.handlers.common.JSONBuilder;
import com.ibm.bi.search.language.ConfigurationContentLocaleMap;
import com.ibm.bi.search.language.ContentLocaleMap;
import com.ibm.bi.search.util.RequestContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;

public class SolrLanguageHandler {
    protected static final String FILTER_SEPARATOR = "\\|";
    protected static final String UNDERSCORE = "_";
    protected static final String LANGUAGE_CODE_CHINESE_TAIWAN = "zh-tw";
    protected static final String LANGUAGE_CODE_CHINESE = "zh-cn";
    protected static final String DEFAULT_LANGUAGE = Locale.ENGLISH.toLanguageTag();
    private static final String SOLR_SUPPORTED_LOCALES_FILE = "/data/supportedLocales.json";
    private static ContentLocaleMap localeMap;
    private static Set<String> supportedLocales;

    public SolrLanguageHandler() {
        SolrLanguageHandler.lazyInitialize();
    }

    private static synchronized void lazyInitialize() {
        if (localeMap == null) {
            localeMap = new ConfigurationContentLocaleMap();
        }
        if (supportedLocales == null) {
            supportedLocales = SolrLanguageHandler.loadSupportedLocales();
        }
    }

    public static synchronized ContentLocaleMap replaceContentLocaleMapForTesting(ContentLocaleMap newLocaleMap) {
        ContentLocaleMap oldLocaleMap = localeMap;
        localeMap = newLocaleMap;
        return oldLocaleMap;
    }

    Set<String> getLanguagesForSearchQueries(String languageParam) {
        return StringUtils.isEmpty((String)languageParam) ? this.getSupportedLanguages() : new HashSet<String>(Arrays.asList(languageParam.split(FILTER_SEPARATOR)));
    }

    Set<String> getLanguagesForSearchFields(String languageParam) {
        return new HashSet<String>(Arrays.asList(StringUtils.isEmpty((String)languageParam) ? this.getUserContentLocale() : languageParam.split(FILTER_SEPARATOR)));
    }

    private String[] getUserContentLocale() {
        Identity identity = RequestContext.getCurrentIdentity();
        String language = Identity.getContentLocaleAsString(identity);
        return new String[]{this.getLanguageCode(language)};
    }

    public String getLanguageCode(String locale) {
        if (locale == null) {
            return locale;
        }
        String mappedLocale = localeMap.getMappedLocale(locale);
        if (SolrLanguageHandler.needsNoTrimming(mappedLocale)) {
            return mappedLocale;
        }
        return StringUtils.substring((String)mappedLocale, (int)0, (int)2);
    }

    private static boolean needsNoTrimming(String language) {
        return LANGUAGE_CODE_CHINESE_TAIWAN.equalsIgnoreCase(language) || SolrLanguageHandler.isDefaultLocale(language);
    }

    private static boolean isDefaultLocale(String language) {
        return FieldNames.DEFAULT_LOCALE.toString().equalsIgnoreCase(language);
    }

    public String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    private static Set<String> loadSupportedLocales() {
        HashSet<String> locales = new HashSet<String>();
        for (Object o : SolrLanguageHandler.getSupportedLocales()) {
            locales.add(o.toString());
        }
        return Collections.unmodifiableSet(locales);
    }

    private static JsonArray getSupportedLocales() {
        return (JsonArray)JSONBuilder.loadJsonFromFile(SolrLanguageHandler.class, SOLR_SUPPORTED_LOCALES_FILE);
    }

    public Map<String, Analyzer> getAnalyzers() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getSupportedLanguages() {
        return supportedLocales;
    }

    public String getUserPreferredLocale(SortedSet<String> availableLocales, String defaultLocale) {
        Identity identity = RequestContext.getCurrentIdentity();
        if (identity != null && identity.getContentLocale() != null) {
            String mappedLocale = localeMap.getMappedLocale(identity.getContentLocale().toLowerCase());
            String solrMappedLocale = this.getSolrSupportedLocaleFromMappedLocale(mappedLocale);
            return SolrLanguageHandler.pickFinalLocaleFromAvailableLocales(solrMappedLocale, availableLocales, defaultLocale);
        }
        return StringUtils.isNotEmpty((String)defaultLocale) ? defaultLocale : DEFAULT_LANGUAGE;
    }

    private String getSolrSupportedLocaleFromMappedLocale(String mappedLocale) {
        String locale = SolrLanguageHandler.trimLocaleIfNeeded(mappedLocale);
        return this.isSupported(locale) ? locale : DEFAULT_LANGUAGE;
    }

    private static String trimLocaleIfNeeded(String mappedLocale) {
        if (LANGUAGE_CODE_CHINESE.equalsIgnoreCase(mappedLocale)) {
            return mappedLocale.substring(0, 2);
        }
        return mappedLocale;
    }

    public boolean isSupported(String locale) {
        return supportedLocales.contains(locale);
    }

    private static String pickFinalLocaleFromAvailableLocales(String preferredLocale, SortedSet<String> availableLocales, String defaultLocale) {
        if (availableLocales.contains(preferredLocale)) {
            return preferredLocale;
        }
        if (StringUtils.isNotEmpty((String)defaultLocale)) {
            return defaultLocale;
        }
        if (!availableLocales.isEmpty()) {
            return availableLocales.first();
        }
        return DEFAULT_LANGUAGE;
    }

    public String getLanguageSpecificFieldName(String name, String language) {
        String languageCode = this.getLanguageCode(language);
        if (StringUtils.isEmpty((String)languageCode)) {
            return name;
        }
        return name + UNDERSCORE + this.getLanguageCode(language);
    }
}

