/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.query;

import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.IndexNames;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import com.ibm.bi.search.language.SolrLanguageHandler;
import com.ibm.bi.search.solr.query.QueryBuilder;
import com.ibm.bi.search.util.SearchConfig;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractQueryBuilder
implements QueryBuilder {
    private static final String BOOST_QUERY_TEMPLATE = "%s:\"%s\"^%.1f";
    private static final float EXACT_NAME_BOOST_FACTOR = 25.0f;
    protected static final String DOC_SECURITY_FILTER = "{!cmDocSecurityFilter}";
    protected final SolrLanguageHandler languageHandler = new SolrLanguageHandler();

    @Override
    public SolrQueryParameters build() {
        SolrQueryParameters parameters = new SolrQueryParameters(new Object[0]);
        if (this.shouldReturnEmptyResult()) {
            return parameters;
        }
        parameters.put("q", this.getQueryTerm());
        parameters.put("q.op", this.getQueryOperator());
        parameters.put("rows", this.getQueryResults());
        parameters.put("qf", this.getQueryFields());
        parameters.put("fq", this.getQueryFilters());
        parameters.put("defType", "edismax");
        parameters.put("fl", "* score");
        if (this.getQueryFacet()) {
            parameters.put("facet", "true");
            this.setFacetProperties(parameters);
        }
        if (this.isHighlightingRequested()) {
            parameters.put("hl", true);
            parameters.put("hl.snippets", 1);
            parameters.put("hl.fl", "*");
            parameters.put("hl.fragsize", "0");
        }
        if (this.shouldAddBoostQueryParameter()) {
            parameters.put("bq", this.getBoostQuery());
        }
        return parameters;
    }

    private boolean shouldAddBoostQueryParameter() {
        return IndexNames.CM.toString().equals(this.getIndexId());
    }

    private String getBoostQuery() {
        return String.format(Locale.US, BOOST_QUERY_TEMPLATE, FieldNames.NAME_EXACT.toString(), this.escapeQuotes(this.getQueryTerm()), Float.valueOf(25.0f));
    }

    private String escapeQuotes(String term) {
        return StringUtils.isNotEmpty((String)term) ? term.replace("\"", "\\\"") : "";
    }

    private String getQueryOperator() {
        return SearchConfig.getQueryOperator();
    }
}

