/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FacetParameterBuilder {
    private final List<String> facets;

    public FacetParameterBuilder(List<String> facets) {
        this.facets = facets;
    }

    public Map<String, String> buildFacetFieldsAndLimits() {
        HashMap<String, String> fieldsAndLimits = new HashMap<String, String>();
        for (String facet : this.facets) {
            String[] fieldAndLimit = facet.split("\\|");
            if (!FacetParameterBuilder.isValidFacet(fieldAndLimit)) continue;
            fieldsAndLimits.put(fieldAndLimit[0], fieldAndLimit[1]);
        }
        return fieldsAndLimits;
    }

    private static boolean isValidFacet(String[] fieldAndLimit) {
        return fieldAndLimit.length == 2 && StringUtils.isNotEmpty((String)fieldAndLimit[0]) && StringUtils.isNotEmpty((String)fieldAndLimit[1]);
    }
}

