/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.query;

import com.ibm.bi.search.util.BoostBuilder;
import com.ibm.bi.search.util.SearchFieldUtils;
import java.util.HashSet;
import java.util.Set;

public class FieldsParameterBuilder {
    private static final String MULTILINGUAL_FIELD_TEMPLATE = "%s_%s";
    private static final String WHITESPACE = " ";
    private final String indexId;
    private final Set<String> fields;
    private final Set<String> languages;

    public FieldsParameterBuilder(String indexId, Set<String> fields, Set<String> languages) {
        this.indexId = indexId;
        this.languages = languages;
        this.fields = this.applyMultilingualTransformation(fields);
    }

    private Set<String> applyMultilingualTransformation(Set<String> originalFields) {
        HashSet<String> multilingualFields = new HashSet<String>();
        for (String field : originalFields) {
            if (SearchFieldUtils.isMultilingualField(this.indexId, field)) {
                this.addMultilingualField(multilingualFields, field);
                continue;
            }
            multilingualFields.add(field);
        }
        return multilingualFields;
    }

    private void addMultilingualField(Set<String> originalFields, String baseField) {
        for (String language : this.languages) {
            originalFields.add(String.format(MULTILINGUAL_FIELD_TEMPLATE, baseField, language));
        }
    }

    public String buildBoostedQF() {
        return FieldsParameterBuilder.generateQFString(this.applyBoostTransformation());
    }

    public String buildQF() {
        return FieldsParameterBuilder.generateQFString(this.fields);
    }

    private Set<String> applyBoostTransformation() {
        BoostBuilder boostBuilder = new BoostBuilder();
        return boostBuilder.createSearchBoosts(this.fields);
    }

    private static String generateQFString(Set<String> boostedFields) {
        return String.join((CharSequence)WHITESPACE, boostedFields).trim();
    }
}

