/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.query;

import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.handlers.common.HideInternal;
import com.ibm.bi.search.util.RequestContext;
import com.ibm.bi.search.util.SearchFieldUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class FilterParameterBuilder {
    private static final String DASH_CHAR = "-";
    private static final String QUOTE_CHAR = "\"";
    private static final String MULTILINGUAL_FIELD_TEMPLATE = "%s_%s";
    private static final String FILTER_TEMPLATE = "(%s:%s)";
    private static final String NEGATE_FILTER_TEMPLATE = "(*:* AND -%s:%s)";
    private static final String WRAP_TEMPLATE = "(%s)";
    private static final int RANGE_FILTER_TERMS_MINIMAL = 2;
    private static final String DEFAULT_INCLUSIVENESS = "true";
    private static final String NO_FILTER = null;
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private final String indexId;
    private final List<String> filters;
    private final HideInternal hideInternal;
    private final Set<String> languages;
    private final String scope;
    private final String ancestors;
    private String filterTemplate;

    public FilterParameterBuilder(String indexId, List<String> filters, HideInternal hideInternal, String scope, String ancestors, Set<String> languages) {
        this.indexId = indexId;
        this.filters = filters;
        this.hideInternal = hideInternal;
        this.languages = languages;
        this.scope = scope;
        this.ancestors = ancestors;
        this.filterTemplate = FILTER_TEMPLATE;
    }

    public String buildFQ() {
        ArrayList<String> fq = new ArrayList<String>();
        for (String filter : this.filters) {
            List<String> fieldAndTerms = this.splitFilterValues(filter);
            String solrFilter = this.createSolrFilterFromLuceneFilter(this.getFilterField(fieldAndTerms), FilterParameterBuilder.getFilterTerms(fieldAndTerms));
            FilterParameterBuilder.addFilterIfValid(fq, solrFilter);
        }
        FilterParameterBuilder.addFilterIfValid(fq, this.createSolrFilterFromHideInternal());
        FilterParameterBuilder.addFilterIfValid(fq, FilterParameterBuilder.createSolrFilterFromHidden());
        FilterParameterBuilder.addFilterIfValid(fq, this.createSolrFilterFromScope());
        FilterParameterBuilder.addFilterIfValid(fq, this.createSolrFilterFromAncestors());
        return String.join((CharSequence)AND, fq);
    }

    private List<String> splitFilterValues(String values) {
        return Arrays.asList(values.split("\\|"));
    }

    private String getFilterField(List<String> fieldAndTerms) {
        String filterField = fieldAndTerms.get(0);
        if (FilterParameterBuilder.isNegateFilter(filterField)) {
            filterField = filterField.substring(1);
            this.filterTemplate = NEGATE_FILTER_TEMPLATE;
        }
        return filterField;
    }

    private static List<String> getFilterTerms(List<String> fieldAndTerms) {
        return fieldAndTerms.subList(1, fieldAndTerms.size());
    }

    private String createSolrFilterFromLuceneFilter(String field, List<String> terms) {
        if (StringUtils.isEmpty((String)field) || CollectionUtils.isEmpty(terms)) {
            return NO_FILTER;
        }
        if (SearchFieldUtils.isMultilingualField(this.indexId, field)) {
            return this.handleMultilingualFilter(field, terms);
        }
        if (this.isRangeField(field)) {
            return FilterParameterBuilder.handleRangeFilter(field, terms);
        }
        return this.handleGenericFilter(field, terms);
    }

    private boolean isRangeField(String field) {
        return SearchFieldUtils.isDateField(this.indexId, field) || SearchFieldUtils.isIntField(this.indexId, field);
    }

    private String handleMultilingualFilter(String fieldName, List<String> filterTerms) {
        ArrayList<String> multilingualFilters = new ArrayList<String>();
        for (String filter : filterTerms) {
            String phraseFilter = FilterParameterBuilder.buildPhraseFilter(filter);
            multilingualFilters.add(this.buildTermFilterPerLanguage(fieldName, phraseFilter));
        }
        return String.join((CharSequence)OR, multilingualFilters);
    }

    private static String buildPhraseFilter(String filter) {
        if (filter.split(" ").length > 1) {
            return FilterParameterBuilder.putInQuotes(filter);
        }
        return filter;
    }

    private static String putInQuotes(String s) {
        String quoted = s;
        if (!quoted.startsWith(QUOTE_CHAR)) {
            quoted = QUOTE_CHAR + quoted;
        }
        if (!quoted.endsWith(QUOTE_CHAR)) {
            quoted = quoted + QUOTE_CHAR;
        }
        return quoted;
    }

    private String buildTermFilterPerLanguage(String fieldName, String term) {
        ArrayList<String> filtersPerLanguage = new ArrayList<String>();
        for (String language : this.languages) {
            String multilingualFieldName = String.format(MULTILINGUAL_FIELD_TEMPLATE, fieldName, language);
            String multilingualTermFilter = String.format(FILTER_TEMPLATE, multilingualFieldName, term);
            filtersPerLanguage.add(multilingualTermFilter);
        }
        return String.join((CharSequence)OR, filtersPerLanguage);
    }

    private static String handleRangeFilter(String fieldName, List<String> filterTerms) {
        if (filterTerms.size() < 2) {
            return NO_FILTER;
        }
        String minValue = filterTerms.get(0);
        String maxValue = filterTerms.get(1);
        String template = FilterParameterBuilder.getRangeFilterTemplate(filterTerms);
        return String.format(template, fieldName, minValue, maxValue);
    }

    private static String getRangeFilterTemplate(List<String> filterTerms) {
        boolean lowerBound = FilterParameterBuilder.getInclusivenessValue(filterTerms, 2);
        boolean upperBound = FilterParameterBuilder.getInclusivenessValue(filterTerms, 3);
        return "%s:" + FilterParameterBuilder.getLowerBoundInclusiveness(lowerBound) + "%s TO %s" + FilterParameterBuilder.getUpperBoundInclusiveness(upperBound);
    }

    private static boolean getInclusivenessValue(List<String> filterTerms, int index) {
        return Boolean.parseBoolean(filterTerms.size() > index ? filterTerms.get(index) : DEFAULT_INCLUSIVENESS);
    }

    private static char getLowerBoundInclusiveness(boolean isInclusive) {
        return isInclusive ? (char)'[' : '{';
    }

    private static char getUpperBoundInclusiveness(boolean isInclusive) {
        return isInclusive ? (char)']' : '}';
    }

    private String handleGenericFilter(String fieldName, List<String> filterTerms) {
        ArrayList<String> genericFilters = new ArrayList<String>();
        for (String term : filterTerms) {
            genericFilters.add(String.format(this.filterTemplate, fieldName, term));
        }
        return String.join((CharSequence)OR, genericFilters);
    }

    private static boolean isNegateFilter(String fieldName) {
        return fieldName.startsWith(DASH_CHAR);
    }

    private static void addFilterIfValid(List<String> addToList, String filter) {
        if (FilterParameterBuilder.isValidFilter(filter)) {
            addToList.add(String.format(WRAP_TEMPLATE, filter));
        }
    }

    private static boolean isValidFilter(String filter) {
        return StringUtils.isNotEmpty((String)filter);
    }

    private String createSolrFilterFromHideInternal() {
        switch (this.hideInternal) {
            case ALL: {
                ArrayList<String> hideInternalFilters = new ArrayList<String>();
                hideInternalFilters.add(FilterParameterBuilder.createUserVisibilityFilter());
                hideInternalFilters.add(FilterParameterBuilder.createIsInternalFilter());
                return String.join((CharSequence)AND, hideInternalFilters);
            }
            case DEFAULT: {
                return FilterParameterBuilder.createUserVisibilityFilter();
            }
        }
        return NO_FILTER;
    }

    private static String createUserVisibilityFilter() {
        ArrayList<String> userVisFilters = new ArrayList<String>();
        userVisFilters.add(String.format(FILTER_TEMPLATE, FieldNames.USER_VISIBILITY.toString(), "all"));
        Identity identity = RequestContext.getCurrentIdentity();
        if (identity != null && identity.getUserStoreID() != null) {
            userVisFilters.add(String.format(FILTER_TEMPLATE, FieldNames.USER_VISIBILITY.toString(), identity.getUserStoreID()));
        }
        return String.format(WRAP_TEMPLATE, String.join((CharSequence)OR, userVisFilters));
    }

    private static String createIsInternalFilter() {
        return String.format(FILTER_TEMPLATE, FieldNames.IS_INTERNAL.toString(), Boolean.FALSE.toString());
    }

    private static String createSolrFilterFromHidden() {
        if (!RequestContext.getShowHiddenObjects() || !RequestContext.getCanUseShowHiddenObjectsPreference()) {
            return String.format(FILTER_TEMPLATE, FieldNames.HIDDEN.toString(), Boolean.FALSE.toString());
        }
        return NO_FILTER;
    }

    private String createSolrFilterFromScope() {
        if (StringUtils.isEmpty((String)this.scope)) {
            return NO_FILTER;
        }
        switch (this.scope) {
            case "mycontent": {
                Identity identity = RequestContext.getCurrentIdentity();
                if (identity != null && identity.getUserStoreID() != null) {
                    return String.format(FILTER_TEMPLATE, FieldNames.USER_VISIBILITY.toString(), identity.getUserStoreID());
                }
                return NO_FILTER;
            }
            case "teamcontent": {
                return String.format(FILTER_TEMPLATE, FieldNames.USER_VISIBILITY.toString(), "all");
            }
        }
        return NO_FILTER;
    }

    private String createSolrFilterFromAncestors() {
        return StringUtils.isNotEmpty((String)this.ancestors) ? this.buildAncestorsFilter() : NO_FILTER;
    }

    private String buildAncestorsFilter() {
        return String.format(FILTER_TEMPLATE, FieldNames.ANCESTORS.toString(), this.buildAncestorsValues());
    }

    private String buildAncestorsValues() {
        List<String> ancestorIds = this.splitFilterValues(this.ancestors);
        if (ancestorIds.size() == 1) {
            return ancestorIds.get(0);
        }
        return String.format(WRAP_TEMPLATE, String.join((CharSequence)OR, ancestorIds));
    }
}

