/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.query;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.handlers.common.QueryResult;
import com.ibm.bi.search.handlers.common.SearchQueryParameters;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import com.ibm.bi.search.handlers.common.SuggestQueryParameters;
import com.ibm.bi.search.indexing.solr.SolrHandlerFactory;
import com.ibm.bi.search.indexing.solr.policies.PermissionCheck;
import com.ibm.bi.search.solr.query.ResultBuilder;
import com.ibm.bi.search.solr.query.SearchQueryBuilder;
import com.ibm.bi.search.solr.query.SuggestQueryBuilder;
import com.ibm.bi.search.util.SearchConfig;
import java.util.Collection;
import java.util.List;

public class QueryExecutor {
    private static final int MAX_NUM_ITERS = 5;
    private final SolrHandlerFactory solrFactory;
    private final ResultBuilder resultBuilder;
    private PermissionCheck permissionChecker;

    public QueryExecutor() {
        this(new SolrHandlerFactory(), new ResultBuilder(), null);
    }

    protected QueryExecutor(PermissionCheck permissionChecker) {
        this(new SolrHandlerFactory(), new ResultBuilder(), permissionChecker);
    }

    protected QueryExecutor(SolrHandlerFactory solrFactory, ResultBuilder resultBuilder, PermissionCheck permissionChecker) {
        this.solrFactory = solrFactory;
        this.resultBuilder = resultBuilder;
        this.permissionChecker = permissionChecker;
    }

    public JsonArray executeSearch(SearchQueryParameters qp) {
        String indexId = qp.getIndexId();
        String returnFields = qp.getReturnFields();
        SearchQueryBuilder queryBuilder = new SearchQueryBuilder(qp);
        return this.buildFinalResults(indexId, queryBuilder.build(), returnFields);
    }

    public JsonArray executeSuggest(SuggestQueryParameters qp, String returnFields) {
        String indexId = qp.getIndexId();
        SuggestQueryBuilder suggestBuilder = new SuggestQueryBuilder(qp);
        return this.getSuggestions(this.buildFinalResults(indexId, suggestBuilder.build(), returnFields));
    }

    private JsonArray execute(String indexId, SolrQueryParameters params) {
        return QueryExecutor.getResults(this.solrFactory.createSolrHandler().query(indexId, params));
    }

    private JsonArray buildFinalResults(String indexId, SolrQueryParameters params, String returnFields) {
        JsonArray finalResults = new JsonArray();
        JsonArray initialResults = this.execute(indexId, params);
        JsonArray builtResults = this.buildResults(indexId, initialResults, returnFields);
        finalResults.addAll((Collection)builtResults);
        int prevStartIndex = 0;
        for (int iters = 0; QueryExecutor.getResultsDifference(initialResults, builtResults) > 0 && iters < 5; ++iters) {
            int startIndex = initialResults.size() + prevStartIndex;
            params.put("start", startIndex);
            params.put("rows", QueryExecutor.getResultsDifference(initialResults, builtResults));
            builtResults = this.buildResults(indexId, this.execute(indexId, params), returnFields);
            finalResults.addAll((Collection)builtResults);
            prevStartIndex = startIndex;
        }
        return finalResults;
    }

    private static int getResultsDifference(JsonArray originalResults, JsonArray builtResults) {
        return originalResults.size() - builtResults.size();
    }

    private JsonArray buildResults(String indexId, JsonArray results, String returnFields) {
        if (SearchConfig.isPostFilterPermissionCheckEnabled()) {
            results = this.callPostFilterPermissionCheck(results);
        }
        return this.resultBuilder.buildSearchResults(indexId, results, returnFields);
    }

    private JsonArray callPostFilterPermissionCheck(JsonArray initialResults) {
        JsonArray finalResults = new JsonArray();
        List<String> validIds = this.getPermissionChecker().getValidBatch(initialResults);
        for (Object o : initialResults) {
            JsonObject initialResult = (JsonObject)o;
            if (!validIds.contains(initialResult.getString(FieldNames.ID.toString()))) continue;
            finalResults.add((Object)initialResult);
        }
        return finalResults;
    }

    private static JsonArray getResults(QueryResult result) {
        return (JsonArray)result.toJSON().get("results");
    }

    private JsonArray getSuggestions(JsonArray results) {
        return this.resultBuilder.buildSuggestResults(results);
    }

    private PermissionCheck getPermissionChecker() {
        if (this.permissionChecker == null) {
            this.permissionChecker = new PermissionCheck();
        }
        return this.permissionChecker;
    }
}

