/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.query;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.constants.SchemaProperties;
import com.ibm.bi.search.handlers.common.HideInternal;
import com.ibm.bi.search.handlers.common.QueryResult;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import com.ibm.bi.search.indexing.solr.SolrHandlerFactory;
import com.ibm.bi.search.indexing.solr.SolrQueryFactory;
import com.ibm.bi.search.indexing.solr.policies.PoliciesCacheFactory;
import com.ibm.bi.search.indexing.solr.policies.SearchPolicyObject;
import com.ibm.bi.search.language.SolrLanguageHandler;
import com.ibm.bi.search.util.Ancestors;
import com.ibm.bi.search.util.RequestContext;
import com.ibm.bi.search.util.SearchFieldUtils;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String FIELDS_SEPARATOR = "[\\|\\,]";
    private static final String SELF_URL_TEMPLATE = "%s/%s/%s";
    private static final String NO_PARENT_ID = "";
    private static final String PERMISSIONS = FieldNames.PERMISSIONS.toString();
    private static final String HIDDEN = FieldNames.HIDDEN.toString();
    private final SolrLanguageHandler languageHandler = new SolrLanguageHandler();
    private final SolrHandlerFactory solrFactory;
    private final SolrQueryFactory queryFactory;
    private final PoliciesCacheFactory policiesFactory;

    public ResultBuilder() {
        this(new SolrHandlerFactory(), new SolrQueryFactory(), new PoliciesCacheFactory());
    }

    protected ResultBuilder(SolrHandlerFactory solrFactory, SolrQueryFactory queryFactory, PoliciesCacheFactory policiesFactory) {
        this.solrFactory = solrFactory;
        this.queryFactory = queryFactory;
        this.policiesFactory = policiesFactory;
    }

    public JsonArray buildSearchResults(String indexId, JsonArray fullResults, String fields) {
        JsonArray finalResults = new JsonArray();
        Set<String> returnFields = this.getReturnFieldsSet(indexId, fields);
        for (Object o : fullResults) {
            JsonObject builtResult;
            JsonObject result = (JsonObject)o;
            if (!this.canBuildResult(result) || !this.canIncludeResult(builtResult = this.buildResultFields(indexId, result, returnFields))) continue;
            finalResults.add((Object)builtResult);
        }
        return finalResults;
    }

    private Set<String> getReturnFieldsSet(String indexId, String originalReturnFields) {
        Set<String> returnableFields = SearchFieldUtils.getReturnableFields(indexId);
        if (StringUtils.isEmpty((String)originalReturnFields)) {
            return returnableFields;
        }
        HashSet<String> returnFieldsSet = new HashSet<String>(Arrays.asList(originalReturnFields.split(FIELDS_SEPARATOR)));
        return returnFieldsSet.stream().filter(returnableFields::contains).collect(Collectors.toSet());
    }

    private boolean canBuildResult(JsonObject result) {
        return !RequestContext.shouldHideUnknown() || !this.hasUnknownFields(result);
    }

    private boolean hasUnknownFields(JsonObject result) {
        return this.isUnknown(result, FieldNames.IS_INTERNAL) || this.isUnknown(result, FieldNames.USER_VISIBILITY);
    }

    private boolean isUnknown(JsonObject result, FieldNames fieldName) {
        String fieldValue = (String)result.get(fieldName.toString());
        if ("unknown".equals(fieldValue)) {
            LOG.debug("Removing object from search results because its {} field is unknown: {}", (Object)fieldName, (Object)result);
            return true;
        }
        return false;
    }

    private boolean canIncludeResult(JsonObject result) {
        JsonArray ancestors = result.getArray(FieldNames.ANCESTORS.toString());
        if (RequestContext.hasHiddenAncestor(ancestors)) {
            LOG.debug("Removing object from search results because it has a hidden ancestor: {}", (Object)result);
            return false;
        }
        if (RequestContext.getHideInternal() != HideInternal.NONE && this.hasNullPermissions(result)) {
            LOG.debug("Removing object from search results because we couldn't retrieve its permissions: {}", (Object)result);
            return false;
        }
        return true;
    }

    private boolean hasNullPermissions(JsonObject result) {
        return result.containsKey((Object)PERMISSIONS) && result.get(PERMISSIONS) == null;
    }

    private JsonObject buildResultFields(String indexId, JsonObject result, Set<String> returnFields) {
        JsonObject builtResult = new JsonObject();
        for (String field : returnFields) {
            builtResult.put(field, this.buildField(indexId, result, field));
        }
        return builtResult;
    }

    private Object buildField(String indexId, JsonObject result, String field) {
        String fieldType;
        switch (fieldType = SearchFieldUtils.getSearchFieldType(indexId, field)) {
            case "ancestors": {
                return this.buildAncestorsOutputField(indexId, result);
            }
            case "parentId": {
                return this.buildParentIdField(result);
            }
            case "multilingual": {
                return ResultBuilder.buildMultilingualOutputField(result, field);
            }
            case "selfURL": {
                return ResultBuilder.buildSelfUrlOutputField(result);
            }
            case "default": {
                return this.buildDefaultLocaleField(result, field);
            }
            case "stringArray": {
                return ResultBuilder.buildStringArrayField(result, field);
            }
            case "grantPermission": {
                return this.buildPermissions(result);
            }
            case "highlighting": {
                return this.buildHighlightingResult(result).get(field);
            }
        }
        return result.get(field);
    }

    private String buildParentIdField(JsonObject result) {
        List<String> ancestorIds = Ancestors.getAncestorIds(result);
        return ResultBuilder.getParentId(ancestorIds);
    }

    private static String getParentId(List<String> ancestorIds) {
        return ancestorIds.isEmpty() ? NO_PARENT_ID : ancestorIds.get(ancestorIds.size() - 1);
    }

    private JsonArray buildAncestorsOutputField(String indexId, JsonObject result) {
        String ancestorPath = Ancestors.getAncestorPath(result);
        return this.queryAncestorDocuments(indexId, ancestorPath);
    }

    private JsonArray queryAncestorDocuments(String indexId, String ancestorPath) {
        List<String> ancestorIds = Ancestors.getAncestorIds(ancestorPath);
        SolrQueryParameters qp = this.queryFactory.createQueryByIds(ancestorIds);
        return this.buildAncestors(ResultBuilder.getSortedAncestors(this.solrFactory.createSolrHandler().query(indexId, qp), ancestorPath));
    }

    private static Map<String, JsonObject> getSortedAncestors(QueryResult result, String ancestorPath) {
        return Ancestors.sortByPath(ancestorPath, (JsonArray)result.toJSON().get("results"));
    }

    private JsonArray buildAncestors(Map<String, JsonObject> ancestorResults) {
        JsonArray builtAncestors = new JsonArray();
        for (JsonObject ancestor : ancestorResults.values()) {
            JsonObject builtAncestor = new JsonObject();
            builtAncestor.put(FieldNames.ID.toString(), (Object)ancestor.getString(FieldNames.ID.toString()));
            builtAncestor.put(FieldNames.TYPE.toString(), (Object)ancestor.getString(FieldNames.TYPE.toString()));
            builtAncestor.put(FieldNames.SELF_URL.toString(), (Object)ResultBuilder.buildSelfUrlOutputField(ancestor));
            builtAncestor.put(FieldNames.DEFAULT_NAME.toString(), (Object)this.buildDefaultLocaleField(ancestor, FieldNames.DEFAULT_NAME.toString()));
            builtAncestor.put(HIDDEN, (Object)ResultBuilder.getObjectHiddenValue(ancestor.getString(HIDDEN)));
            builtAncestors.add((Object)builtAncestor);
        }
        return builtAncestors;
    }

    private static JsonObject buildMultilingualOutputField(JsonObject result, String fieldName) {
        JsonObject localeMap = new JsonObject();
        for (String multilingualField : result.keySet()) {
            if (!multilingualField.startsWith(fieldName)) continue;
            localeMap.put(ResultBuilder.getMultilingualLocale(multilingualField), result.get(multilingualField));
        }
        return localeMap;
    }

    private static String getMultilingualLocale(String multilingualField) {
        ArrayList<String> fieldNameAndLocale = new ArrayList<String>(Arrays.asList(multilingualField.split("_")));
        return (String)fieldNameAndLocale.get(1);
    }

    private static String buildSelfUrlOutputField(JsonObject result) {
        return String.format(SELF_URL_TEMPLATE, RequestContext.getBaseURL(), SchemaProperties.OBJECTS.toString(), result.getString(FieldNames.ID.toString()));
    }

    private String buildDefaultLocaleField(JsonObject result, String fieldName) {
        String baseFieldName = ResultBuilder.getBaseField(fieldName);
        JsonObject multilingualField = ResultBuilder.buildMultilingualOutputField(result, baseFieldName);
        String defaultLocale = ResultBuilder.getDefaultLocale(result, baseFieldName);
        String preferredLocale = this.getPreferredLocale(multilingualField, defaultLocale);
        return ResultBuilder.getDefaultFieldValue(multilingualField, preferredLocale);
    }

    private JsonObject buildHighlightingResult(JsonObject result) {
        result.put("highlighting", (Object)this.getHighlightingResult(result));
        return result;
    }

    private JsonArray getHighlightingResult(JsonObject highlight) {
        if (highlight.get("highlighting") != null) {
            return (JsonArray)highlight.get("highlighting");
        }
        return new JsonArray();
    }

    private static String getBaseField(String fieldName) {
        return fieldName.substring("default".length()).toLowerCase();
    }

    private static String getDefaultLocale(JsonObject result, String baseFieldName) {
        return (String)result.get("defaultLocale_" + baseFieldName);
    }

    private String getPreferredLocale(JsonObject multilingualField, String defaultLocale) {
        return this.languageHandler.getUserPreferredLocale(new TreeSet<String>(multilingualField.keySet()), defaultLocale);
    }

    private static String getDefaultFieldValue(JsonObject multilingualField, String preferredLocale) {
        JsonArray values;
        Object defaultField = ResultBuilder.getField(multilingualField, preferredLocale);
        if (defaultField instanceof String) {
            return (String)defaultField;
        }
        if (defaultField instanceof JsonArray && !(values = (JsonArray)defaultField).isEmpty()) {
            return (String)values.get(0);
        }
        return NO_PARENT_ID;
    }

    private static Object getField(JsonObject multilingualField, String preferredLocale) {
        return StringUtils.isEmpty((String)preferredLocale) ? null : multilingualField.get(preferredLocale);
    }

    private static String getObjectHiddenValue(String hidden) {
        return Boolean.toString(RequestContext.hideObject(hidden));
    }

    private static JsonArray buildStringArrayField(JsonObject result, String fieldName) {
        if (result.getArray(fieldName) == null) {
            return new JsonArray();
        }
        return result.getArray(fieldName);
    }

    public JsonArray buildSuggestResults(JsonArray results) {
        LinkedHashSet<String> suggestResults = new LinkedHashSet<String>();
        JsonArray builtResults = new JsonArray();
        for (Object o : results) {
            JsonObject result = (JsonObject)o;
            suggestResults.add(result.getString(FieldNames.DEFAULT_NAME.toString()));
        }
        for (String result : suggestResults) {
            builtResults.add((Object)result);
        }
        return builtResults;
    }

    private JsonArray buildPermissions(JsonObject result) {
        SearchPolicyObject object = this.policiesFactory.getPoliciesCache().retrieve(result.getString(FieldNames.ID.toString()));
        Identity currIdentity = RequestContext.getCurrentIdentity();
        return object != null ? object.getGrantedPermissions(currIdentity) : null;
    }
}

