/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.query;

import com.ibm.bi.search.handlers.common.SearchQueryParameters;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import com.ibm.bi.search.solr.query.AbstractQueryBuilder;
import com.ibm.bi.search.solr.query.FacetParameterBuilder;
import com.ibm.bi.search.solr.query.FieldsParameterBuilder;
import com.ibm.bi.search.solr.query.FilterParameterBuilder;
import com.ibm.bi.search.util.SearchConfig;
import com.ibm.bi.search.util.SearchFieldUtils;
import com.ibm.bi.search.util.SearchUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SearchQueryBuilder
extends AbstractQueryBuilder {
    private static final String WILDCARD = "*";
    private static final String NO_QUERY_FIELDS = "";
    private final SearchQueryParameters queryParams;

    public SearchQueryBuilder(SearchQueryParameters queryParams) {
        this.queryParams = queryParams;
    }

    @Override
    public boolean shouldReturnEmptyResult() {
        return this.queryExistsButIsEmpty() || this.allSearchableValuesAreEmpty();
    }

    private boolean queryExistsButIsEmpty() {
        return this.queryParams.getQueryTerm() != null && this.queryParams.getQueryTerm().trim().isEmpty();
    }

    private boolean allSearchableValuesAreEmpty() {
        return StringUtils.isEmpty((String)this.queryParams.getQueryTerm()) && CollectionUtils.isEmpty(this.queryParams.getFacet()) && CollectionUtils.isEmpty(this.queryParams.getFilters());
    }

    @Override
    public String getIndexId() {
        return this.queryParams.getIndexId();
    }

    @Override
    public String getQueryTerm() {
        if (StringUtils.isEmpty((String)this.queryParams.getQueryTerm())) {
            return WILDCARD;
        }
        return SearchUtils.escapeSolrKeywords(this.queryParams.getQueryTerm());
    }

    @Override
    public int getQueryResults() {
        return this.queryParams.getMaxResults();
    }

    @Override
    public String getQueryFields() {
        HashSet<String> queryFields = new HashSet<String>();
        if (SearchUtils.isPhraseQuery(this.queryParams.getQueryTerm())) {
            queryFields.addAll(SearchFieldUtils.getPhraseSearchableFields(this.getIndexId()));
        } else {
            queryFields.addAll(SearchFieldUtils.getSearchableFields(this.getIndexId()));
        }
        if (queryFields.isEmpty()) {
            return NO_QUERY_FIELDS;
        }
        FieldsParameterBuilder fieldsBuilder = new FieldsParameterBuilder(this.getIndexId(), queryFields, this.getLanguagesParameter());
        return fieldsBuilder.buildBoostedQF();
    }

    @Override
    public List<String> getQueryFilters() {
        FilterParameterBuilder filterBuilder = new FilterParameterBuilder(this.getIndexId(), this.getFilterParameter(), this.queryParams.getHideInternal(), this.queryParams.getScope(), this.queryParams.getAncestors(), this.getLanguagesParameter());
        ArrayList<String> filterQueries = new ArrayList<String>();
        if (!SearchConfig.isPostFilterPermissionCheckEnabled()) {
            filterQueries.add("{!cmDocSecurityFilter}");
        }
        filterQueries.add(filterBuilder.buildFQ());
        return filterQueries;
    }

    @Override
    public boolean getQueryFacet() {
        return true;
    }

    @Override
    public void setFacetProperties(SolrQueryParameters parameters) {
        if (this.getFacetParameter().isEmpty()) {
            return;
        }
        FacetParameterBuilder facetBuilder = new FacetParameterBuilder(this.queryParams.getFacet());
        SearchQueryBuilder.mapFacetsToQueryParameters(parameters, facetBuilder.buildFacetFieldsAndLimits());
    }

    private static void mapFacetsToQueryParameters(SolrQueryParameters solrQueryParams, Map<String, String> facetFields) {
        for (Map.Entry<String, String> entry : facetFields.entrySet()) {
            String fieldName = entry.getKey();
            String fieldLimit = entry.getValue();
            solrQueryParams.put("facet.field", fieldName);
            solrQueryParams.put(String.format("f.%s.facet.limit", fieldName), fieldLimit);
        }
    }

    private List<String> getFilterParameter() {
        if (CollectionUtils.isEmpty(this.queryParams.getFilters())) {
            return Collections.emptyList();
        }
        return this.queryParams.getFilters();
    }

    protected List<String> getFacetParameter() {
        if (CollectionUtils.isEmpty(this.queryParams.getFacet())) {
            return Collections.emptyList();
        }
        return this.queryParams.getFacet();
    }

    private Set<String> getLanguagesParameter() {
        return StringUtils.isEmpty((String)this.queryParams.getLang()) ? this.languageHandler.getSupportedLanguages() : Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(this.queryParams.getLang().split("\\|"))));
    }

    @Override
    public boolean isHighlightingRequested() {
        return this.queryParams.getReturnFields() != null && this.queryParams.getReturnFields().contains("highlighting");
    }
}

