/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.query;

import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.handlers.common.SolrQueryParameters;
import com.ibm.bi.search.handlers.common.SuggestQueryParameters;
import com.ibm.bi.search.solr.query.AbstractQueryBuilder;
import com.ibm.bi.search.solr.query.FieldsParameterBuilder;
import com.ibm.bi.search.solr.query.FilterParameterBuilder;
import com.ibm.bi.search.util.SearchConfig;
import com.ibm.bi.search.util.SearchUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SuggestQueryBuilder
extends AbstractQueryBuilder {
    private static final Set<String> SUGGEST_QUERY_FIELDS = new HashSet<String>(Arrays.asList(FieldNames.NAME.toString(), FieldNames.NAME_EXACT.toString(), FieldNames.NAME_PARTIAL.toString(), FieldNames.NAME_WHITESPACE.toString()));
    private final SuggestQueryParameters suggestParams;

    public SuggestQueryBuilder(SuggestQueryParameters suggestParams) {
        this.suggestParams = suggestParams;
    }

    @Override
    public boolean shouldReturnEmptyResult() {
        return StringUtils.isEmpty((String)this.suggestParams.getQueryTerm());
    }

    @Override
    public String getIndexId() {
        return this.suggestParams.getIndexId();
    }

    @Override
    public String getQueryTerm() {
        return SearchUtils.escapeSolrKeywords(this.suggestParams.getQueryTerm());
    }

    @Override
    public int getQueryResults() {
        return this.suggestParams.getMaxResults();
    }

    @Override
    public String getQueryFields() {
        FieldsParameterBuilder fieldsBuilder = new FieldsParameterBuilder(this.getIndexId(), SUGGEST_QUERY_FIELDS, this.getLanguagesParameter());
        return fieldsBuilder.buildBoostedQF();
    }

    @Override
    public List<String> getQueryFilters() {
        FilterParameterBuilder filterBuilder = new FilterParameterBuilder(this.getIndexId(), this.getFilterParameter(), this.suggestParams.getHideInternal(), null, this.suggestParams.getAncestors(), this.getLanguagesParameter());
        ArrayList<String> filterQueries = new ArrayList<String>();
        if (!SearchConfig.isPostFilterPermissionCheckEnabled()) {
            filterQueries.add("{!cmDocSecurityFilter}");
        }
        filterQueries.add(filterBuilder.buildFQ());
        return filterQueries;
    }

    @Override
    public boolean getQueryFacet() {
        return false;
    }

    @Override
    public void setFacetProperties(SolrQueryParameters params) {
        throw new UnsupportedOperationException();
    }

    private List<String> getFilterParameter() {
        if (CollectionUtils.isEmpty(this.suggestParams.getFilters())) {
            return Collections.emptyList();
        }
        return this.suggestParams.getFilters();
    }

    private Set<String> getLanguagesParameter() {
        return this.languageHandler.getSupportedLanguages();
    }

    @Override
    public boolean isHighlightingRequested() {
        return false;
    }
}

