/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.queryparser;

import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.handlers.common.HideInternal;
import com.ibm.bi.search.indexing.solr.policies.PoliciesCacheFactory;
import com.ibm.bi.search.indexing.solr.policies.PolicyType;
import com.ibm.bi.search.indexing.solr.policies.SearchPolicyObject;
import com.ibm.bi.search.util.Ancestors;
import com.ibm.bi.search.util.RequestContext;
import com.ibm.bi.search.util.SearchUtils;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmDocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Identity identity;
    private String documentId;
    private PoliciesCacheFactory policiesFactory;

    public CmDocumentValidator(Identity identity, String documentId) {
        this(identity, documentId, new PoliciesCacheFactory());
    }

    protected CmDocumentValidator(Identity identity, String documentId, PoliciesCacheFactory policiesFactory) {
        this.identity = identity;
        this.documentId = documentId;
        this.policiesFactory = policiesFactory;
    }

    public boolean validateAccess() {
        if (this.hasNothingToHide()) {
            if (RequestContext.shouldHideUnknown() && this.hasNoPolicy()) {
                LOG.debug("Hiding object {} from system admin because its policy is missing.", (Object)this.documentId);
                return false;
            }
            LOG.trace("Accepting object {} because request is from a system admin asking not to hide internal objects.", (Object)this.documentId);
            return true;
        }
        SearchPolicyObject policy = this.getPolicies(this.documentId);
        if (policy == null) {
            LOG.debug("Rejecting object {} because its policy object could not be determined.", (Object)this.documentId);
            return false;
        }
        if (CmDocumentValidator.isHidden(policy)) {
            LOG.trace("Rejecting object {} because it is hidden.", (Object)this.documentId);
            return false;
        }
        Set<SearchPolicyObject> ancestors = this.constructDocumentHierarchy(policy);
        if (RequestContext.hasHiddenAncestor(ancestors)) {
            LOG.trace("Rejecting object {} because it's ancestor is hidden.", (Object)this.documentId);
            return false;
        }
        if (this.identity.isSystemAdmin()) {
            LOG.trace("Accepting object {} because request user is system administrator.", (Object)this.documentId);
            return true;
        }
        if (this.isUserUnboundedTenantAdmin()) {
            return this.userIsGrantedPermissionUpTree(policy, ancestors);
        }
        return this.doesUserBelongToTenant(policy) && this.userIsGrantedPermissionUpTree(policy, ancestors);
    }

    private boolean hasNothingToHide() {
        return this.identity.isSystemAdmin() && RequestContext.getHideInternal() == HideInternal.NONE;
    }

    private boolean hasNoPolicy() {
        return !this.policiesFactory.getPoliciesCache().exists(this.documentId);
    }

    private SearchPolicyObject getPolicies(String id) {
        return this.policiesFactory.getPoliciesCache().retrieve(id);
    }

    private static boolean isHidden(SearchPolicyObject policy) {
        return RequestContext.hideObject(policy.getHidden());
    }

    private Set<SearchPolicyObject> constructDocumentHierarchy(SearchPolicyObject policy) {
        LinkedHashSet<SearchPolicyObject> documentHierarchy = new LinkedHashSet<SearchPolicyObject>();
        List<String> ancestorIds = Ancestors.getAncestorIds(policy.getAncestorPath());
        for (String ancestorId : ancestorIds) {
            SearchPolicyObject ancestorPolicy = this.getPolicies(ancestorId);
            if (ancestorPolicy == null) continue;
            documentHierarchy.add(ancestorPolicy);
        }
        return documentHierarchy;
    }

    private boolean isUserDocumentOwner(SearchPolicyObject policy) {
        String docOwner = policy.getOwner();
        return docOwner != null && docOwner.equalsIgnoreCase(this.identity.getUserStoreID());
    }

    private boolean isUserUnboundedTenantAdmin() {
        return this.identity.isTenantAdmin() && !this.identity.isViewLimited();
    }

    private boolean userIsGrantedPermissionUpTree(SearchPolicyObject policy, Set<SearchPolicyObject> ancestors) {
        return this.isGrantedPermission(policy) && this.isGrantedPermissionUpTree(ancestors);
    }

    private boolean isGrantedPermission(SearchPolicyObject policy) {
        if (policy.isDisabled()) {
            return this.userHasWriteOrSetPolicy(policy);
        }
        return this.userHasAnyGrantPermission(policy);
    }

    private boolean userHasWriteOrSetPolicy(SearchPolicyObject policy) {
        return this.userHasGranularPermission(PolicyType.WRITE, policy) || this.userHasGranularPermission(PolicyType.SET_POLICY, policy);
    }

    private boolean userHasGranularPermission(PolicyType granularity, SearchPolicyObject policy) {
        if (this.isUserDocumentOwner(policy)) {
            return true;
        }
        List<String> camIDs = this.identity.getCAMIds();
        switch (granularity) {
            case READ: {
                return SearchUtils.listContainsAny(policy.getReadGrant(), camIDs) && !SearchUtils.listContainsAny(policy.getReadDeny(), camIDs);
            }
            case WRITE: {
                return SearchUtils.listContainsAny(policy.getWriteGrant(), camIDs) && !SearchUtils.listContainsAny(policy.getWriteDeny(), camIDs);
            }
            case EXECUTE: {
                return SearchUtils.listContainsAny(policy.getExecuteGrant(), camIDs) && !SearchUtils.listContainsAny(policy.getExecuteDeny(), camIDs);
            }
            case SET_POLICY: {
                return SearchUtils.listContainsAny(policy.getSetPolicyGrant(), camIDs) && !SearchUtils.listContainsAny(policy.getSetPolicyDeny(), camIDs);
            }
            case TRAVERSE: {
                return SearchUtils.listContainsAny(policy.getTraverseGrant(), camIDs) && !SearchUtils.listContainsAny(policy.getTraverseDeny(), camIDs);
            }
        }
        return false;
    }

    private boolean userHasAnyGrantPermission(SearchPolicyObject policy) {
        for (PolicyType policyType : PolicyType.getAcceptedPolicyTypes()) {
            if (!this.userHasGranularPermission(policyType, policy)) continue;
            return true;
        }
        return false;
    }

    private boolean isGrantedPermissionUpTree(Set<SearchPolicyObject> ancestors) {
        for (SearchPolicyObject ancestor : ancestors) {
            if (!(ancestor.isDisabled() ? !this.userHasWriteOrSetPolicy(ancestor) || !this.userHasGranularPermission(PolicyType.TRAVERSE, ancestor) : !this.userHasGranularPermission(PolicyType.TRAVERSE, ancestor))) continue;
            return false;
        }
        return true;
    }

    private boolean doesUserBelongToTenant(SearchPolicyObject policy) {
        String tenantID = policy.getTenantID();
        return "publictenant".equals(tenantID) || this.identity.getTenantIDs().contains(tenantID);
    }

    public boolean needsToCheckPolicies() {
        return !this.hasNothingToHide();
    }
}

