/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.queryparser;

import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.solr.queryparser.CmDocumentValidator;
import com.ibm.bi.search.util.RequestContext;
import com.ibm.bi.search.util.SearchConfig;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.UUID;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.PostFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmDocumentVisibilityQParser
extends ExtendedQueryBase
implements PostFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MAX_COST = 100;
    private final String uuid = UUID.randomUUID().toString();

    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        return new DelegatingCollector(){
            private SortedDocValues documents;
            private int collectCount = 0;

            public void collect(int docID) throws IOException {
                Identity identity = RequestContext.getCurrentIdentity();
                if (this.documents.advanceExact(docID)) {
                    int ord = this.documents.ordValue();
                    BytesRef bytes = this.documents.lookupOrd(ord);
                    String documentId = bytes.utf8ToString();
                    CmDocumentValidator validator = new CmDocumentValidator(identity, documentId);
                    if (this.maxCollectReached(validator)) {
                        LOG.debug("Max number of collect() calls reached ({}).", (Object)this.collectCount);
                        throw new CollectionTerminatedException();
                    }
                    if (validator.validateAccess()) {
                        super.collect(docID);
                    }
                }
            }

            private boolean maxCollectReached(CmDocumentValidator validator) {
                return validator.needsToCheckPolicies() && ++this.collectCount > SearchConfig.getMaxCollectCount();
            }

            public void doSetNextReader(LeafReaderContext context) throws IOException {
                this.documents = context.reader().getSortedDocValues(FieldNames.ID.toString());
                super.doSetNextReader(context);
            }
        };
    }

    public boolean getCache() {
        return false;
    }

    public int getCost() {
        return Math.max(super.getCost(), 100);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CmDocumentVisibilityQParser) {
            CmDocumentVisibilityQParser other = (CmDocumentVisibilityQParser)((Object)o);
            return this.uuid.equals(other.uuid);
        }
        return false;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

