/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.queryparser;

import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.solr.similarity.ElasticSearchDisjunctionMaxQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;

public class ElasticSearchDismaxQParser
extends QParser {
    private static final String WHITESPACE = " ";
    private static final String EXPONENT_REGEX = "\\^";
    private static final int EXPECTED_SIZE_WITH_PROPER_BOOST = 2;
    private static final Float DEFAULT_BOOST_VALUE = Float.valueOf(1.0f);

    public ElasticSearchDismaxQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    public Query parse() throws SyntaxError {
        Map<String, Float> fieldsAndBoosts = this.getQueryFieldsSplitByWhitespace();
        Map<String, List<String>> fieldsAndTerms = this.getQueryFieldsAndAnalyzedTerms(fieldsAndBoosts.keySet());
        return this.generateElasticDismaxQuery(fieldsAndTerms, fieldsAndBoosts);
    }

    private Map<String, List<String>> getQueryFieldsAndAnalyzedTerms(Set<String> fieldNames) {
        HashMap<String, List<String>> fieldsAndTerms = new HashMap<String, List<String>>();
        for (String fieldName : fieldNames) {
            fieldsAndTerms.put(fieldName, this.getAnalyzedQueryTerms(fieldName));
        }
        return fieldsAndTerms;
    }

    private List<String> getAnalyzedQueryTerms(String fieldName) {
        if (this.requestContainsSchemaWithAnalyzers()) {
            Analyzer analyzer = this.req.getSchema().getQueryAnalyzer();
            return this.streamQueryToTokenizedTerms(analyzer, fieldName);
        }
        return ElasticSearchDismaxQParser.splitStringOnWhitespace(this.qstr);
    }

    private boolean requestContainsSchemaWithAnalyzers() {
        return this.req != null && this.req.getSchema() != null && this.req.getSchema().getQueryAnalyzer() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> streamQueryToTokenizedTerms(Analyzer analyzer, String fieldName) {
        ArrayList<String> tokens = new ArrayList<String>();
        try (TokenStream ts = analyzer.tokenStream(fieldName, this.qstr);){
            CharTermAttribute termAttribute = (CharTermAttribute)ts.getAttribute(CharTermAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                tokens.add(termAttribute.toString());
            }
            ArrayList<String> arrayList = tokens;
            return arrayList;
        }
        catch (IOException ioE) {
            throw new SearchException(SearchMessageKeys.INVALID_DATA_FORMAT, ioE);
        }
    }

    private Map<String, Float> getQueryFieldsSplitByWhitespace() {
        HashMap<String, Float> queryFields = new HashMap<String, Float>();
        for (String qf : ElasticSearchDismaxQParser.splitStringOnWhitespace(this.params.get("qf"))) {
            List<String> qfAndBoost = Arrays.asList(qf.split(EXPONENT_REGEX));
            queryFields.put(qfAndBoost.get(0), ElasticSearchDismaxQParser.getBoostValue(qfAndBoost));
        }
        return queryFields;
    }

    private static Float getBoostValue(List<String> qfAndBoost) {
        return qfAndBoost.size() == 2 ? Float.valueOf(qfAndBoost.get(1)) : DEFAULT_BOOST_VALUE;
    }

    private static List<String> splitStringOnWhitespace(String str) {
        if (StringUtils.isNotEmpty((String)str)) {
            return Arrays.asList(str.split(WHITESPACE));
        }
        return Collections.emptyList();
    }

    private Query generateElasticDismaxQuery(Map<String, List<String>> fieldsAndTerms, Map<String, Float> fieldsAndBoosts) {
        ArrayList<Query> dismaxTermQueries = new ArrayList<Query>();
        for (Map.Entry<String, List<String>> entry : fieldsAndTerms.entrySet()) {
            String fieldName = entry.getKey();
            dismaxTermQueries.add(ElasticSearchDismaxQParser.createBooleanQuery(fieldName, entry.getValue(), fieldsAndBoosts.get(fieldName)));
        }
        return new ElasticSearchDisjunctionMaxQuery(dismaxTermQueries, ElasticSearchDismaxQParser.splitStringOnWhitespace(this.qstr));
    }

    private static Query createBooleanQuery(String fieldName, List<String> terms, Float boost) {
        BooleanQuery.Builder boolQuery = new BooleanQuery.Builder();
        for (String term : terms) {
            boolQuery.add((Query)ElasticSearchDismaxQParser.createBoostQuery(fieldName, term, boost), BooleanClause.Occur.SHOULD);
        }
        return boolQuery.build();
    }

    private static BoostQuery createBoostQuery(String field, String term, Float boost) {
        return new BoostQuery((Query)ElasticSearchDismaxQParser.createTermQuery(field, term), boost.floatValue());
    }

    private static TermQuery createTermQuery(String field, String term) {
        return new TermQuery(new Term(field, term));
    }
}

