/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.queryparser;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.PostFilter;

public class SecurityFilterQParser
extends ExtendedQueryBase
implements PostFilter {
    private static final String COMMA = ",";
    private static final String ASSET_REF = "assetRef";
    private static final int MAX_COST = 100;
    private final Set<String> assetRefs;

    public SecurityFilterQParser(String assetRefs) {
        this.assetRefs = new HashSet<String>(Arrays.asList(assetRefs.split(COMMA)));
    }

    public boolean getCache() {
        return false;
    }

    public int getCost() {
        return Math.max(super.getCost(), 100);
    }

    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        return new DelegatingCollector(){
            SortedDocValues ids;

            protected void doSetNextReader(LeafReaderContext context) throws IOException {
                this.ids = context.reader().getSortedDocValues(SecurityFilterQParser.ASSET_REF);
                super.doSetNextReader(context);
            }

            public void collect(int doc) throws IOException {
                String documentAssetRef = this.getAssetRef(doc);
                if (this.userHasPermissionToAssetRef(documentAssetRef)) {
                    super.collect(doc);
                }
            }

            private String getAssetRef(int doc) throws IOException {
                return this.ids.advanceExact(doc) ? this.ids.binaryValue().utf8ToString() : null;
            }

            private boolean userHasPermissionToAssetRef(String documentAssetRef) {
                return SecurityFilterQParser.this.assetRefs.contains(documentAssetRef);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SecurityFilterQParser) {
            SecurityFilterQParser other = (SecurityFilterQParser)((Object)o);
            return this.assetRefs.equals(other.assetRefs);
        }
        return false;
    }

    public int hashCode() {
        return this.assetRefs.hashCode();
    }
}

