/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.similarity;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.lucene.search.DocIdSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticDocIdSetIterator
extends DocIdSetIterator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<DocIdSetIterator> iterators;
    private boolean wasNextDocOrAdvancedCalled;

    public ElasticDocIdSetIterator(List<DocIdSetIterator> iterators) {
        this.iterators = iterators;
    }

    public int docID() {
        if (!this.wasNextDocOrAdvancedCalled) {
            return -1;
        }
        int lowestDocID = Integer.MAX_VALUE;
        for (DocIdSetIterator iterator : this.iterators) {
            int currentDocID = iterator.docID();
            if (currentDocID >= lowestDocID) continue;
            lowestDocID = currentDocID;
        }
        return lowestDocID;
    }

    public int nextDoc() throws IOException {
        this.wasNextDocOrAdvancedCalled = true;
        int currentDoc = this.docID();
        for (DocIdSetIterator iterator : this.iterators) {
            if (iterator.docID() != currentDoc) continue;
            iterator.nextDoc();
        }
        return this.docID();
    }

    public int advance(int target) throws IOException {
        this.wasNextDocOrAdvancedCalled = true;
        for (DocIdSetIterator iterator : this.iterators) {
            this.advanceIterator(iterator, target);
        }
        return this.docID();
    }

    private void advanceIterator(DocIdSetIterator iterator, int target) {
        try {
            iterator.advance(target);
        }
        catch (Exception e) {
            LOG.trace("Ignoring exception from Lucene while advancing iterator: {}", (Object)e.toString());
        }
    }

    public long cost() {
        return 1L;
    }
}

