/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.similarity;

import com.ibm.bi.search.solr.similarity.ElasticDocIdSetIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;

public class ElasticSearchDisjunctionMaxQuery
extends Query {
    private static final int HASH_CODE_MULTIPLIER = 31;
    private final List<String> termsInQuery;
    private final Query[] disjuncts;

    public ElasticSearchDisjunctionMaxQuery(Collection<Query> disjuncts, List<String> termsInQuery) {
        this.disjuncts = disjuncts.toArray(new Query[disjuncts.size()]);
        this.termsInQuery = termsInQuery;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode mode, float boost) throws IOException {
        float queryNorm = this.calculateQueryNorm(searcher);
        return new ElasticSearchDisjunctionMaxWeight(this, searcher, mode, boost, queryNorm);
    }

    private float calculateQueryNorm(IndexSearcher searcher) throws IOException {
        float maxSumOfSquaredWeights = 0.0f;
        for (Query disjunct : this.disjuncts) {
            BooleanQuery query = (BooleanQuery)disjunct;
            float sumOfSquaredWeights = this.calculateSumOfSquaredWeights(query, searcher);
            if (!(sumOfSquaredWeights > maxSumOfSquaredWeights)) continue;
            maxSumOfSquaredWeights = sumOfSquaredWeights;
        }
        return maxSumOfSquaredWeights == 0.0f ? 1.0f : (float)(1.0 / Math.sqrt(maxSumOfSquaredWeights));
    }

    private float calculateSumOfSquaredWeights(BooleanQuery query, IndexSearcher searcher) throws IOException {
        float sumOfSquares = 0.0f;
        for (BooleanClause clause : query.clauses()) {
            BoostQuery boostQuery = (BoostQuery)clause.getQuery();
            float boost = boostQuery.getBoost();
            TermQuery termQuery = (TermQuery)boostQuery.getQuery();
            String fieldName = termQuery.getTerm().field();
            String term = termQuery.getTerm().text();
            sumOfSquares += this.computeSumOfSquaredWeights(searcher, fieldName, term, boost);
        }
        return sumOfSquares;
    }

    private float computeSumOfSquaredWeights(IndexSearcher searcher, String fieldName, String term, float boost) throws IOException {
        CollectionStatistics collectionStats = searcher.collectionStatistics(fieldName);
        if (collectionStats == null) {
            return 0.0f;
        }
        float docCount = collectionStats.docCount();
        float docFreq = searcher.count((Query)new TermQuery(new Term(fieldName, term)));
        float idf = (float)(Math.log((docCount + 1.0f) / (docFreq + 1.0f)) + 1.0);
        return idf * boost * (idf * boost);
    }

    public String toString(String field) {
        return "ElasticSearchDisjunctionMaxQuery";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ElasticSearchDisjunctionMaxQuery) {
            ElasticSearchDisjunctionMaxQuery other = (ElasticSearchDisjunctionMaxQuery)((Object)o);
            return Arrays.equals(this.disjuncts, other.disjuncts);
        }
        return false;
    }

    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + Arrays.hashCode(this.disjuncts);
        return h;
    }

    public List<Query> getDisjunctsForTesting() {
        return Arrays.asList(this.disjuncts);
    }

    public class ElasticSearchDisjunctionMaxWeight
    extends Weight {
        private final List<Weight> weights;
        private final float queryNorm;

        public ElasticSearchDisjunctionMaxWeight(ElasticSearchDisjunctionMaxQuery edismax, IndexSearcher searcher, ScoreMode mode, float boost, float queryNorm) throws IOException {
            super((Query)edismax);
            this.weights = new ArrayList<Weight>();
            this.queryNorm = queryNorm;
            for (Query query : ElasticSearchDisjunctionMaxQuery.this.disjuncts) {
                this.weights.add(query.createWeight(searcher, mode, boost));
            }
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        public void extractTerms(Set<Term> terms) {
            for (Weight weight : this.weights) {
                weight.extractTerms(terms);
            }
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return Explanation.noMatch((String)"No matching clauses...", (Explanation[])new Explanation[0]);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            ArrayList<Scorer> scorers = new ArrayList<Scorer>();
            for (Weight weight : this.weights) {
                Scorer scorer = weight.scorer(context);
                if (scorer == null) continue;
                scorers.add(scorer);
            }
            ArrayList<DocIdSetIterator> iterators = new ArrayList<DocIdSetIterator>();
            for (Scorer scorer : scorers) {
                if (scorer == null) continue;
                iterators.add(scorer.iterator());
            }
            return new ElasticSearchDisjunctionMaxScorer(this, scorers, iterators);
        }

        public class ElasticSearchDisjunctionMaxScorer
        extends Scorer {
            private final List<Scorer> scorers;
            private final List<DocIdSetIterator> iterators;
            private DocIdSetIterator iterInstance;

            public ElasticSearchDisjunctionMaxScorer(Weight weight, List<Scorer> scorers, List<DocIdSetIterator> iterators) {
                super(weight);
                this.scorers = scorers;
                this.iterators = iterators;
            }

            public DocIdSetIterator iterator() {
                this.iterInstance = new ElasticDocIdSetIterator(this.iterators);
                return this.iterInstance;
            }

            public float getMaxScore(int upTo) throws IOException {
                return this.score();
            }

            public float score() throws IOException {
                float maxScore = 0.0f;
                for (int i = 0; i < this.scorers.size() && i < this.iterators.size(); ++i) {
                    Scorer scorer;
                    if (this.docID() != this.iterators.get(i).docID() || (scorer = this.scorers.get(i)) == null) continue;
                    float coord = this.hasChildren(scorer) ? this.coord(scorer.getChildren().size()) : this.coord(1);
                    float currentScore = scorer.score() * coord * ElasticSearchDisjunctionMaxWeight.this.queryNorm;
                    if (!(currentScore > maxScore)) continue;
                    maxScore = currentScore;
                }
                return maxScore;
            }

            private boolean hasChildren(Scorer scorer) throws IOException {
                Collection children = scorer.getChildren();
                return CollectionUtils.isNotEmpty((Collection)children);
            }

            private float coord(int numTermsHit) {
                return (float)numTermsHit / (float)ElasticSearchDisjunctionMaxQuery.this.termsInQuery.size();
            }

            public int docID() {
                return this.iterInstance.docID();
            }
        }
    }
}

