/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.similarity;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.SmallFloat;

public class SmartsScorer
extends Similarity.SimScorer {
    private static final int NOT_SURE = 255;
    private static final int MAX_NORM_SIZE = 256;
    private static final float[] NORM_TABLE = new float[256];
    private final Explanation idf;
    private final float boost;

    public SmartsScorer(float boost, Explanation idf) {
        this.idf = idf;
        this.boost = boost;
    }

    public float score(float freq, long norm) {
        float queryScore = this.boost * this.idf.getValue().floatValue();
        float fieldScore = this.tf(freq) * this.idf.getValue().floatValue() * NORM_TABLE[this.decodeNorm(norm)];
        return queryScore * fieldScore;
    }

    private int decodeNorm(long norm) {
        return (int)(norm & 0xFFL);
    }

    public float idf(long docFreq, long docCount) {
        return (float)(Math.log((double)(docCount + 1L) / (double)(docFreq + 1L)) + 1.0);
    }

    public float tf(float freq) {
        return (float)Math.sqrt(freq);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            SmartsScorer.NORM_TABLE[i] = SmallFloat.byte315ToFloat((byte)((byte)i));
        }
    }
}

