/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.solr.similarity;

import com.ibm.bi.search.solr.similarity.SmartsScorer;
import java.util.ArrayList;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.SmallFloat;

public class SmartsSimilarity
extends Similarity {
    private static final boolean DISCOUNT_OVERLAPS = true;

    public float tf(float freq) {
        return (float)Math.sqrt(freq);
    }

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics termStats) {
        long df = termStats.docFreq();
        long docCount = collectionStats.docCount();
        float idf = this.idf(df, docCount);
        return Explanation.match((Number)Float.valueOf(idf), (String)"idf(docFreq, docCount)", (Explanation[])new Explanation[]{Explanation.match((Number)df, (String)"docFreq, number of documents containing term", (Explanation[])new Explanation[0]), Explanation.match((Number)docCount, (String)"docCount, total number of documents with field", (Explanation[])new Explanation[0])});
    }

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics[] termStats) {
        double idf = 0.0;
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        for (TermStatistics stat : termStats) {
            Explanation idfExplain = this.idfExplain(collectionStats, stat);
            subs.add(idfExplain);
            idf += (double)idfExplain.getValue().floatValue();
        }
        return Explanation.match((Number)Float.valueOf((float)idf), (String)"idf(), sum of:", subs);
    }

    public float idf(long docFreq, long docCount) {
        return (float)(Math.log((double)(docCount + 1L) / (double)(docFreq + 1L)) + 1.0);
    }

    public final long computeNorm(FieldInvertState state) {
        int numTerms = state.getLength() - state.getNumOverlap();
        return SmallFloat.floatToByte315((float)((float)(1.0 / Math.sqrt(numTerms))));
    }

    public final Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Explanation idf = termStats.length == 1 ? this.idfExplain(collectionStats, termStats[0]) : this.idfExplain(collectionStats, termStats);
        return new SmartsScorer(boost, idf);
    }
}

