/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.constants.FieldNames;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Ancestors {
    private static final String ANCESTORS_FIELD = FieldNames.ANCESTORS.toString();
    private static final String ID_FIELD = FieldNames.ID.toString();
    private static final String SLASH = "/";
    private static final String NO_ANCESTORS = null;

    private Ancestors() {
    }

    public static String getAncestorPath(JsonObject document) {
        Object value = document.get(ANCESTORS_FIELD);
        if (value instanceof String) {
            return (String)value;
        }
        return Ancestors.getFirstAncestorPath(document);
    }

    private static String getFirstAncestorPath(JsonObject document) {
        JsonArray ancestors = document.getArray(ANCESTORS_FIELD);
        if (ancestors == null || ancestors.isEmpty()) {
            return NO_ANCESTORS;
        }
        return ancestors.getString(0);
    }

    public static List<String> getAncestorIds(String ancestorPath) {
        if (StringUtils.isEmpty((String)ancestorPath) || SLASH.equals(ancestorPath)) {
            return Collections.emptyList();
        }
        ancestorPath = Ancestors.removeLeadingCharacterFromString(ancestorPath, SLASH);
        return Arrays.asList(ancestorPath.trim().split(SLASH));
    }

    private static String removeLeadingCharacterFromString(String word, String character) {
        if (word.startsWith(character)) {
            return word.substring(1);
        }
        return word;
    }

    public static List<String> getAncestorIds(JsonObject document) {
        String ancestorPath = Ancestors.getAncestorPath(document);
        return Ancestors.getAncestorIds(ancestorPath);
    }

    public static Map<String, JsonObject> sortByPath(String ancestorPath, JsonArray originalAncestors) {
        Map<String, JsonObject> unsortedAncestors = Ancestors.getUnsortedAncestors(originalAncestors);
        LinkedHashMap<String, JsonObject> sortedAncestors = new LinkedHashMap<String, JsonObject>();
        List<String> orderedIds = Ancestors.getAncestorIds(ancestorPath);
        for (String id : orderedIds) {
            if (unsortedAncestors.get(id) == null) continue;
            sortedAncestors.put(id, unsortedAncestors.get(id));
        }
        return sortedAncestors;
    }

    private static Map<String, JsonObject> getUnsortedAncestors(JsonArray originalAncestors) {
        HashMap<String, JsonObject> ancestors = new HashMap<String, JsonObject>();
        for (Object o : originalAncestors) {
            JsonObject ancestor = (JsonObject)o;
            ancestors.put(ancestor.getString(ID_FIELD), ancestor);
        }
        return ancestors;
    }
}

