/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.language.SolrLanguageHandler;
import com.ibm.bi.search.util.RequestContext;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class BoostBuilder {
    private static final String NAME = "name_";
    private static final String NAME_LOCALE = "name_%s";
    private static final String DESCRIPTION = "description_";
    private static final String DESCRIPTION_LOCALE = "description_%s";
    private static final String NAME_EXACT = "name_exact";
    private static final float EXACT_NAME_BOOST_FACTOR = 25.0f;
    private static final float NAME_CONTENT_LOCALE_BOOST_FACTOR = 20.5f;
    private static final float NAME_BOOST_FACTOR = 8.0f;
    private static final float DESCRIPTION_CONTENT_LOCALE_BOOST_FACTOR = 6.0f;
    private static final float DESCRIPTION_BOOST_FACTOR = 4.0f;
    private static final float DEFAULT_BOOST_FACTOR = 1.0f;
    private static final String BOOSTED_FIELD_TEMPLATE = "%s^%.1f";

    public Set<String> createSearchBoosts(Set<String> fields) {
        HashSet<String> fieldsWithBoosts = new HashSet<String>();
        for (String fieldName : fields) {
            Float boost = Float.valueOf(1.0f);
            if (fieldName.equalsIgnoreCase(NAME_EXACT)) {
                boost = Float.valueOf(25.0f);
            } else if (fieldName.equals(this.getFieldForIdentityContentLocale(NAME_LOCALE))) {
                boost = Float.valueOf(20.5f);
            } else if (fieldName.toLowerCase().startsWith(NAME)) {
                boost = Float.valueOf(8.0f);
            } else if (fieldName.equals(this.getFieldForIdentityContentLocale(DESCRIPTION_LOCALE))) {
                boost = Float.valueOf(6.0f);
            } else if (fieldName.toLowerCase().startsWith(DESCRIPTION)) {
                boost = Float.valueOf(4.0f);
            }
            fieldsWithBoosts.add(String.format(Locale.US, BOOSTED_FIELD_TEMPLATE, fieldName, boost));
        }
        return fieldsWithBoosts;
    }

    private String getFieldForIdentityContentLocale(String baseFieldName) {
        String contentLocale = Identity.getContentLocaleAsString(RequestContext.getCurrentIdentity());
        String langCode = new SolrLanguageHandler().getLanguageCode(contentLocale);
        return String.format(baseFieldName, langCode);
    }
}

