/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.lang.invoke.MethodHandles;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigStringProperty {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final DynamicStringProperty property;
    private final String propertyName;
    private final String defaultValue;
    private final String sysPropValue;
    private String currentValue;
    private Runnable propertyCallback = this::savePropertyValue;

    public ConfigStringProperty(String propertyName, String defaultValue) {
        this(propertyName, defaultValue, ConfigurationPropertyFactory.getInstance());
    }

    protected ConfigStringProperty(String propertyName, String defaultValue, ConfigurationPropertyFactory factory) {
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
        this.sysPropValue = System.getProperty(propertyName);
        this.property = factory.getStringProperty(propertyName, this.getActualDefaultValue());
        this.property.addCallback(this.propertyCallback);
        this.savePropertyValue();
    }

    private String getActualDefaultValue() {
        return this.sysPropValue != null ? this.sysPropValue : this.defaultValue;
    }

    private void savePropertyValue() {
        this.setValue(this.property.get());
    }

    public String getValue() {
        if (this.shouldUseSystemProperty()) {
            return this.sysPropValue;
        }
        return this.currentValue;
    }

    private boolean shouldUseSystemProperty() {
        return this.sysPropValue != null && StringUtils.equals((CharSequence)this.currentValue, (CharSequence)this.defaultValue);
    }

    public void setValue(String newValue) {
        this.currentValue = newValue;
        LOG.debug("Config property [{}] changed to [{}]", (Object)this.propertyName, (Object)this.getValue());
    }
}

