/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.search.util.SearchConfig;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileURIUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String FILE_SCHEME = "file";
    private static final String UNC_PREFIX = "\\\\";

    private FileURIUtils() {
    }

    public static String resolveURIDirectory(String directoryPath) {
        if (!StringUtils.isEmpty((String)directoryPath)) {
            directoryPath = directoryPath.trim();
            return FileURIUtils.extractPathFromURI(URI.create(directoryPath));
        }
        return null;
    }

    private static String extractPathFromURI(URI uri) {
        if (!FILE_SCHEME.equalsIgnoreCase(uri.getScheme())) {
            LOG.debug("Invalid URI scheme : '{}'. URI scheme 'file' is expected.", (Object)uri.getScheme());
            return null;
        }
        StringBuilder path = new StringBuilder();
        String uriPath = uri.getPath();
        if (SearchConfig.isRunningWindows()) {
            String authority = uri.getAuthority();
            if (authority != null) {
                path.append(UNC_PREFIX + authority);
            } else if (uriPath.startsWith("/")) {
                uriPath = uriPath.substring(1);
            }
        }
        path.append(uriPath);
        if (!FileURIUtils.validateURILocation(path.toString())) {
            LOG.debug("Invalid URI location : '{}'. This location does not exist.", (Object)path);
            return null;
        }
        return path.toString();
    }

    static boolean validateURILocation(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return false;
        }
        File file = new File(path);
        if (!file.exists()) {
            LOG.debug("Attempting to create folder at : '{}'.", (Object)path);
            return file.mkdir();
        }
        return true;
    }
}

