/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.util.BIService;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String TENANCY = "tenancy";
    private static final String SELF = "self";
    private static final String TENANTID = "tenantID";
    private static final String READTENANTIDS = "readTenantIDs";
    private static final String UPS_INTERNAL_IDENTITY_PATH = "identity/internal";
    private RESTClient client;

    public IdentityBuilder(RESTClient client) {
        this.client = client;
    }

    public Identity createUserIdentity() throws IOException {
        this.client.setRequestHeader("If-Modified-Since", null);
        int status = this.client.getResource(BIService.getPath(UPS_INTERNAL_IDENTITY_PATH));
        if (status == 200) {
            List<String> camIds = null;
            String tenantID = null;
            List<String> listOfReadTenantIds = null;
            JsonObject object = this.client.getResponseAsJsonObject();
            if (object != null) {
                camIds = IdentityBuilder.getTheListOfIdentityCAMIds(object);
                tenantID = IdentityBuilder.getSessionTenantId(object);
                listOfReadTenantIds = IdentityBuilder.getTheListOfReadTenantIds(object);
                return new Identity(camIds, tenantID, listOfReadTenantIds);
            }
        }
        LOG.error("Error retrieving identity - {}", (Object)this.client.getErrorResponseString());
        return null;
    }

    private static List<String> getTheListOfReadTenantIds(JsonObject saCamIdentity) {
        JsonObject tenancy = saCamIdentity.getObject(TENANCY);
        if (tenancy == null) {
            return Collections.emptyList();
        }
        JsonArray readTenantIds = tenancy.getArray(READTENANTIDS);
        if (readTenantIds == null) {
            return Collections.emptyList();
        }
        ArrayList<String> listOfReadTenantIds = new ArrayList<String>();
        for (Object readTenantId : readTenantIds) {
            listOfReadTenantIds.add((String)readTenantId);
        }
        return listOfReadTenantIds;
    }

    private static List<String> getTheListOfIdentityCAMIds(JsonObject saCamIdentity) {
        JsonArray objArray = saCamIdentity.getArray(SELF);
        if (objArray != null) {
            return Arrays.asList(objArray.toArray((Object[])new String[0]));
        }
        return Collections.emptyList();
    }

    private static String getSessionTenantId(JsonObject saCamIdentity) {
        JsonObject tenancy = saCamIdentity.getObject(TENANCY);
        return tenancy != null ? (String)tenancy.get(TENANTID) : "";
    }
}

