/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.util.BIConfig;
import com.ibm.bi.search.util.SearchConfig;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingBiConfig
extends BIConfig {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_SLEEP_BETWEEN_RETRIES = 1000;
    private static final int DEFAULT_MAX_RETRIES = 600;
    private static int sleepBetweenRetries = 1000;
    private static int maxRetries = 600;
    private ConfigurationPropertyFactory cpf;

    public PollingBiConfig() {
        this(null);
    }

    protected PollingBiConfig(ConfigurationPropertyFactory cpf) {
        this.cpf = cpf;
    }

    @Override
    public void callWhenReady(Consumer<ConfigurationPropertyFactory> callback) {
        this.lazyInitializeConfigurationPropertyFactory();
        String dataDir = this.getDataDirectory();
        LOG.info("BI Configuration is ready. Data directory is {}", (Object)dataDir);
        callback.accept(this.cpf);
    }

    private void lazyInitializeConfigurationPropertyFactory() {
        if (this.cpf == null) {
            this.cpf = ConfigurationPropertyFactory.getInstance();
        }
    }

    private String getDataDirectory() {
        int retries = 0;
        String dataDir = SearchConfig.getDataDirectory(this.cpf);
        while (this.isNotAvailable(dataDir)) {
            this.checkMaxRetries(++retries);
            this.sleep(sleepBetweenRetries);
            dataDir = SearchConfig.getDataDirectory(this.cpf);
        }
        return dataDir;
    }

    private boolean isNotAvailable(String dataDir) {
        return "default".equals(dataDir);
    }

    private void checkMaxRetries(int retries) {
        if (retries > maxRetries) {
            throw new SearchException(SearchMessageKeys.INTERNAL_ERROR, "Timed out waiting for BI Configuration to be ready");
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for BI Configuration to be ready.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    static void setMaxRetries(int maxRetries) {
        PollingBiConfig.maxRetries = maxRetries;
    }

    static void setSleepBetweenRetries(int sleepBetweenRetries) {
        PollingBiConfig.sleepBetweenRetries = sleepBetweenRetries;
    }

    static void reset() {
        PollingBiConfig.setMaxRetries(600);
        PollingBiConfig.setSleepBetweenRetries(1000);
    }
}

