/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import com.ibm.bi.platform.commons.shared.UserPreferences;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.rest.UserProfile;
import com.ibm.bi.search.util.IdentityBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

public class RESTHandlerUtil {
    private static Identity testIdentity = null;
    private static Boolean testHasUserCapability = null;
    private static UserPreferences testUserPreferences = null;
    private static RESTClientFactory clientFactory = RESTClientFactory.getInstance();
    private static boolean isIntegrationTest = false;

    private RESTHandlerUtil() {
    }

    public static void reset() {
        RESTHandlerUtil.setTestIdentity(null, null);
        RESTHandlerUtil.setTestHasUserCapability(null);
        RESTHandlerUtil.setTestUserPreferences(null);
        RESTHandlerUtil.setClientFactoryForTesting(RESTClientFactory.getInstance());
        RESTHandlerUtil.setIntegrationTestFlag(false);
    }

    public static JsonObject parseJSONObject(String jsonString) {
        JsonParser parser = new JsonParser();
        JsonObject sentDocumentObj = null;
        try {
            sentDocumentObj = (JsonObject)parser.parse((Reader)new StringReader(jsonString));
        }
        catch (IOException e) {
            throw new SearchException(SearchMessageKeys.INVALID_DATA_FORMAT, e);
        }
        return sentDocumentObj;
    }

    public static JsonArray parseJSONArray(String jsonString) {
        JsonParser parser = new JsonParser();
        JsonArray sentDocumentObj = null;
        try {
            sentDocumentObj = (JsonArray)parser.parse((Reader)new StringReader(jsonString));
        }
        catch (IOException e) {
            throw new SearchException(SearchMessageKeys.INVALID_DATA_FORMAT, e);
        }
        return sentDocumentObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getUserCapability(HttpServletRequest request, String capability) {
        if (testHasUserCapability != null) {
            return testHasUserCapability;
        }
        try (RESTClient client = clientFactory.getClient(request);){
            UserProfile userCapabilities = new UserProfile(client);
            JsonArray capabilities = userCapabilities.getUserCapabilities();
            boolean bl = capabilities != null && capabilities.contains((Object)capability);
            return bl;
        }
        catch (Exception e) {
            throw SearchException.wrap(e, "Failed to get user capability", new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Identity getUserIdentity(HttpServletRequest theRequest) {
        if (testIdentity != null) {
            if (!testIdentity.isUnauthenticated()) return testIdentity;
            throw new SearchException(SearchMessageKeys.AUTHENTICATON_REQUIRED, 401);
        }
        try (RESTClient client = clientFactory.getClient(theRequest);){
            Identity identity = new IdentityBuilder(client).createUserIdentity();
            if (identity == null) {
                throw new SearchException(SearchMessageKeys.AUTHENTICATON_REQUIRED, 401);
            }
            UserProfile userProfile = new UserProfile(client);
            identity.setUpLocales(userProfile.getProductLocale(), userProfile.getContentLocale());
            identity.setUserStoreID(userProfile.getUserID());
            Identity identity2 = identity;
            return identity2;
        }
        catch (IOException e) {
            throw new SearchException(SearchMessageKeys.AUTHENTICATON_REQUIRED, 401, (Exception)e);
        }
    }

    public static void setTestIdentity(Identity identity, String storeID) {
        RESTHandlerUtil.setTestIdentity(identity, storeID, null);
    }

    public static void setTestIdentity(Identity identity, String storeID, String contentLocale) {
        testIdentity = identity;
        if (testIdentity != null) {
            testIdentity.setUserStoreID(storeID);
            testIdentity.setContentLocale(contentLocale);
        }
    }

    public static void setTestHasUserCapability(Boolean hasUserCapability) {
        testHasUserCapability = hasUserCapability;
    }

    public static void setTestUserPreferences(UserPreferences userPreferences) {
        testUserPreferences = userPreferences;
    }

    public static UserPreferences getTestUserPreferences() {
        return testUserPreferences;
    }

    public static Response checkRequestPreconditions(Request request, Date lastModified) {
        Response.ResponseBuilder builder;
        if (lastModified != null && (builder = request.evaluatePreconditions(lastModified)) != null) {
            return builder.build();
        }
        return null;
    }

    public static void setIntegrationTestFlag(boolean isIT) {
        isIntegrationTest = isIT;
    }

    public static boolean isIntegrationTest() {
        return isIntegrationTest;
    }

    public static RESTClientFactory getClientFactory() {
        return clientFactory;
    }

    public static void setClientFactoryForTesting(RESTClientFactory factory) {
        clientFactory = factory;
    }
}

