/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.search.common.Identity;
import com.ibm.bi.search.constants.FieldNames;
import com.ibm.bi.search.handlers.common.HideInternal;
import com.ibm.bi.search.indexing.solr.policies.SearchPolicyObject;
import java.util.ListIterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public final class RequestContext {
    private static ThreadLocal<Identity> identity = new ThreadLocal();
    private static ThreadLocal<String> baseURL = new ThreadLocal();
    private static ThreadLocal<Boolean> showHiddenObjects = new ThreadLocal();
    private static ThreadLocal<Boolean> canUseShowHiddenObjectsPreference = new ThreadLocal();
    private static ThreadLocal<String> trustedServiceId = new ThreadLocal();
    private static ThreadLocal<Boolean> ignoreHiddenAncestor = new ThreadLocal();
    private static ThreadLocal<HttpServletRequest> httpRequest = new ThreadLocal();
    private static ThreadLocal<HideInternal> hideInternal = new ThreadLocal();
    private static ThreadLocal<Boolean> hideUnknown = new ThreadLocal();

    private RequestContext() {
    }

    public static void close() {
        identity.remove();
        baseURL.remove();
        showHiddenObjects.remove();
        canUseShowHiddenObjectsPreference.remove();
        trustedServiceId.remove();
        ignoreHiddenAncestor.remove();
        httpRequest.remove();
        hideInternal.remove();
        hideUnknown.remove();
    }

    public static void setCurrentIdentity(Identity anIdentity) {
        identity.set(anIdentity);
    }

    public static Identity getCurrentIdentity() {
        return identity.get();
    }

    public static void setBaseURL(String theBaseURL) {
        baseURL.set(theBaseURL);
    }

    public static String getBaseURL() {
        return baseURL.get();
    }

    public static void setShowHiddenObjects(Boolean show) {
        showHiddenObjects.set(show);
    }

    public static boolean getShowHiddenObjects() {
        return RequestContext.safeBooleanValue(showHiddenObjects.get());
    }

    private static boolean safeBooleanValue(Boolean value) {
        return value != null && value != false;
    }

    public static void setCanUseShowHiddenObjectsPreference(Boolean canUseShowHiddenObjPref) {
        canUseShowHiddenObjectsPreference.set(canUseShowHiddenObjPref);
    }

    public static boolean getCanUseShowHiddenObjectsPreference() {
        return RequestContext.safeBooleanValue(canUseShowHiddenObjectsPreference.get());
    }

    public static void setTrustedServiceId(String serviceId) {
        trustedServiceId.set(serviceId);
    }

    public static String getTrustedServiceId() {
        return trustedServiceId.get();
    }

    public static boolean hideObject(String hiddenProperty) {
        return Boolean.valueOf(hiddenProperty) != false && (!RequestContext.getShowHiddenObjects() || !RequestContext.getCanUseShowHiddenObjectsPreference());
    }

    public static boolean hasHiddenAncestor(JsonArray ancestors) {
        if (!RequestContext.ignoreHiddenAncestor() && ancestors != null && !ancestors.isEmpty()) {
            ListIterator ancestorIterator = ancestors.listIterator(ancestors.size());
            return RequestContext.iterateOverAncestors(ancestorIterator);
        }
        return false;
    }

    private static boolean iterateOverAncestors(ListIterator<Object> ancestorIterator) {
        JsonObject ancestor;
        while (!RequestContext.isNamespaceOrNamespaceFolder(ancestor = (JsonObject)ancestorIterator.previous())) {
            if (RequestContext.hideObject(ancestor.getString(FieldNames.HIDDEN.toString()))) {
                return true;
            }
            if (ancestorIterator.hasPrevious()) continue;
        }
        return false;
    }

    public static boolean hasHiddenAncestor(Set<SearchPolicyObject> ancestorPolicies) {
        JsonArray ancestorsJson = new JsonArray();
        if (ancestorPolicies != null && !ancestorPolicies.isEmpty()) {
            for (SearchPolicyObject policy : ancestorPolicies) {
                ancestorsJson.add((Object)policy.toJson());
            }
        }
        return RequestContext.hasHiddenAncestor(ancestorsJson);
    }

    private static boolean isNamespaceOrNamespaceFolder(JsonObject ancestor) {
        String classType = ancestor.getString(FieldNames.TYPE.toString());
        return classType != null && (classType.equals("namespace") || classType.equals("namespaceFolder"));
    }

    public static void setIgnoreHiddenAncestor(boolean ignore) {
        ignoreHiddenAncestor.set(ignore);
    }

    private static boolean ignoreHiddenAncestor() {
        return RequestContext.safeBooleanValue(ignoreHiddenAncestor.get());
    }

    public static void setHttpRequest(HttpServletRequest request) {
        httpRequest.set(request);
    }

    public static HttpServletRequest getHttpRequest() {
        return httpRequest.get();
    }

    public static void setHideInternal(HideInternal value) {
        hideInternal.set(value);
    }

    public static HideInternal getHideInternal() {
        return hideInternal.get();
    }

    public static void setHideUnknown(boolean value) {
        hideUnknown.set(value);
    }

    public static boolean shouldHideUnknown() {
        return RequestContext.safeBooleanValue(hideUnknown.get());
    }
}

