/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.search.util.ConfigStringProperty;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;

public class SearchConfig {
    public static final String EMBEDDED_SOLR_SERVER_URL = "";
    public static final String ENABLED = Boolean.TRUE.toString();
    public static final String DISABLED = Boolean.FALSE.toString();
    private static ConfigStringProperty solrServerURL = new ConfigStringProperty("SearchService.solrServerURL", "");
    private static ConfigStringProperty enableEOSIndexing = new ConfigStringProperty("SearchService.enableEOSIndexing", DISABLED);
    private static ConfigStringProperty eosExcelOutputSizeLimitMB = new ConfigStringProperty("SearchService.eosExcelOutputSizeLimitMB", "10");
    private static ConfigStringProperty indexCommitIntervalSeconds = new ConfigStringProperty("SearchService.indexCommitIntervalSeconds", "60");
    private static ConfigStringProperty initTimeoutMilliseconds = new ConfigStringProperty("SearchService.initTimeoutMilliseconds", "600000");
    private static ConfigStringProperty cleanTimeoutMilliseconds = new ConfigStringProperty("SearchService.cleanTimeoutMilliseconds", "1200000");
    private static ConfigStringProperty cmAssetQueryResults = new ConfigStringProperty("SearchService.cmAssetQueryResults", "10000");
    private static ConfigStringProperty navFilter = new ConfigStringProperty("Content_Service.permissionsFilter", "traverse,read,execute,setPolicy,write");
    private static ConfigStringProperty enablePostFilterPermissionCheck = new ConfigStringProperty("SearchService.enablePostFilterPermissionCheck", DISABLED);
    private static ConfigStringProperty maxTraceMsgLength = new ConfigStringProperty("SearchService.maxTraceMsgLength", "1000");
    private static ConfigStringProperty policiesCacheMaxSize = new ConfigStringProperty("SearchService.policiesCacheMaxSize", "20000");
    private static ConfigStringProperty maxCollectCount = new ConfigStringProperty("SearchService.maxCollectCount", "10000");
    private static ConfigStringProperty enableThreadPools = new ConfigStringProperty("SearchService.enableThreadPools", ENABLED);
    private static ConfigStringProperty longDurationThreadPoolSize = new ConfigStringProperty("SearchService.longDurationThreadPoolSize", "2");
    private static ConfigStringProperty terminationTimeoutInMillis = new ConfigStringProperty("SearchService.terminationTimeoutInMillis", "20000");
    private static ConfigStringProperty queryOperator = new ConfigStringProperty("SearchService.queryOperator", "OR");
    private static final String SEARCH_DIRECTORY = "/search";
    private static final String COLLECTIONS_DIRECTORY = "/collections";
    private static final String TEMP_DIRECTORY = "/temp";
    private static String dataDirectory = SearchConfig.getDataDirectory(ConfigurationPropertyFactory.getInstance());
    private static final String CONFIGURATION_DIRECTORY;
    private static String productConfigDirectory;
    static final String DEFAULT_STATIC_COLLECTIONS_DIRECTORY;
    private static final String STATIC_COLLECTIONS_DIRECTORY;
    private static String staticCollectionsDirectory;
    private static String cmURL;

    private SearchConfig() {
    }

    private static String getInstallDir() {
        return System.getProperty("install.dir");
    }

    public static String getDataDirectory() {
        return dataDirectory;
    }

    public static void setDataDirectory(String configDataDirectory) {
        dataDirectory = configDataDirectory;
    }

    public static String getProductConfigDirectory() {
        return productConfigDirectory;
    }

    public static void setProductConfigDirectory(String directory) {
        productConfigDirectory = directory;
    }

    public static String getCollectionsDirectory() {
        return SearchConfig.getDataDirectory() + SEARCH_DIRECTORY + COLLECTIONS_DIRECTORY;
    }

    public static String getTempDirectory() {
        return SearchConfig.getDataDirectory() + SEARCH_DIRECTORY + TEMP_DIRECTORY;
    }

    public static void setSolrServerURL(String url) {
        solrServerURL.setValue(url);
    }

    public static String getSolrServerURL() {
        return solrServerURL.getValue();
    }

    public static Integer getIndexCommitIntervalSeconds() {
        return Integer.parseInt(indexCommitIntervalSeconds.getValue());
    }

    public static void setIndexCommitIntervalSeconds(Integer interval) {
        indexCommitIntervalSeconds.setValue(String.valueOf(interval));
    }

    public static Integer getInitTimeoutMilliseconds() {
        return Integer.parseInt(initTimeoutMilliseconds.getValue());
    }

    public static void setInitTimeoutMilliseconds(Integer timeout) {
        initTimeoutMilliseconds.setValue(String.valueOf(timeout));
    }

    public static Integer getCleanTimeoutMilliseconds() {
        return Integer.parseInt(cleanTimeoutMilliseconds.getValue());
    }

    public static void setCleanTimeoutMilliseconds(Integer timeout) {
        cleanTimeoutMilliseconds.setValue(String.valueOf(timeout));
    }

    public static Integer getCmAssetQueryResults() {
        return Integer.parseInt(cmAssetQueryResults.getValue());
    }

    public static void setCmAssetQueryResults(Integer results) {
        cmAssetQueryResults.setValue(String.valueOf(results));
    }

    public static boolean isEOSIndexingEnabled() {
        return Boolean.parseBoolean(enableEOSIndexing.getValue());
    }

    public static void setEnableEOSIndexing(String enabled) {
        enableEOSIndexing.setValue(enabled);
    }

    public static Integer getEosExcelOutputSizeLimitMB() {
        return Integer.parseInt(eosExcelOutputSizeLimitMB.getValue());
    }

    public static void setEosExcelOutputSizeLimitMB(Integer size) {
        eosExcelOutputSizeLimitMB.setValue(String.valueOf(size));
    }

    public static boolean isRunningWindows() {
        String osName = System.getProperty("os.name");
        return StringUtils.startsWithIgnoreCase((String)osName, (String)"windows");
    }

    public static String getNavFilter() {
        return navFilter.getValue();
    }

    public static void setNavFilter(String filter) {
        navFilter.setValue(filter);
    }

    public static String getCMUrl() {
        if (cmURL == null) {
            cmURL = ConfigurationPropertyFactory.getInstance().getStringProperty("contentManager", null).get();
        }
        return cmURL;
    }

    public static void setCMUrl(String url) {
        cmURL = url;
    }

    public static boolean isPostFilterPermissionCheckEnabled() {
        return Boolean.parseBoolean(enablePostFilterPermissionCheck.getValue());
    }

    public static void enablePostFilterPermissionCheck(boolean enabled) {
        enablePostFilterPermissionCheck.setValue(Boolean.toString(enabled));
    }

    public static void setMaxTraceMsgLength(int value) {
        maxTraceMsgLength.setValue(String.valueOf(value));
    }

    public static int getMaxTraceMsgLength() {
        return Integer.parseInt(maxTraceMsgLength.getValue());
    }

    public static Integer getPoliciesCacheMaxSize() {
        return Integer.parseInt(policiesCacheMaxSize.getValue());
    }

    public static void setPoliciesCacheSize(int size) {
        policiesCacheMaxSize.setValue(String.valueOf(size));
    }

    public static int getMaxCollectCount() {
        return Integer.parseInt(maxCollectCount.getValue());
    }

    public static void setMaxCollectCount(int value) {
        maxCollectCount.setValue(String.valueOf(value));
    }

    public static boolean areThreadPoolsEnabled() {
        return Boolean.parseBoolean(enableThreadPools.getValue());
    }

    public static void setEnableThreadPools(Boolean enabled) {
        enableThreadPools.setValue(enabled.toString());
    }

    public static int getLongDurationThreadPoolSize() {
        return Integer.parseInt(longDurationThreadPoolSize.getValue());
    }

    public static void setLongDurationThreadPoolSize(int value) {
        longDurationThreadPoolSize.setValue(String.valueOf(value));
    }

    public static long getTerminationTimeoutInMillis() {
        return Long.parseLong(terminationTimeoutInMillis.getValue());
    }

    public static void setTerminationTimeoutInMillis(long value) {
        terminationTimeoutInMillis.setValue(String.valueOf(value));
    }

    public static String getStaticCollectionsDirectory() {
        if (Files.exists(Paths.get(staticCollectionsDirectory, new String[0]), new LinkOption[0])) {
            return staticCollectionsDirectory;
        }
        return DEFAULT_STATIC_COLLECTIONS_DIRECTORY;
    }

    public static void setStaticCollectionsDirectory(String directory) {
        staticCollectionsDirectory = directory;
    }

    public static void resetStaticCollectionsDirectory() {
        staticCollectionsDirectory = STATIC_COLLECTIONS_DIRECTORY;
    }

    public static void setQueryOperator(String op) {
        queryOperator.setValue(op);
    }

    public static String getQueryOperator() {
        return queryOperator.getValue();
    }

    static String getDataDirectory(ConfigurationPropertyFactory cpf) {
        return StringUtils.isNotBlank((String)System.getProperty("data.dir")) ? System.getProperty("data.dir") : cpf.getStringProperty("data").get();
    }

    static {
        productConfigDirectory = CONFIGURATION_DIRECTORY = SearchConfig.getInstallDir() + "/configuration/search";
        DEFAULT_STATIC_COLLECTIONS_DIRECTORY = SearchConfig.getInstallDir() + "/search/data/search/collections/indices/collections";
        staticCollectionsDirectory = STATIC_COLLECTIONS_DIRECTORY = SearchConfig.getInstallDir() + "/search/collections";
    }
}

