/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.search.common.SearchException;
import com.ibm.bi.search.common.SearchMessageKeys;
import com.ibm.bi.search.constants.FieldNames;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SearchFieldUtils {
    public static final String ANCESTORS_FIELD = "ancestors";
    public static final String PARENT_ID_FIELD = "parentId";
    public static final String CONTENT_FIELD = "content";
    public static final String CONTRIBUTED_FIELD = "contributed";
    public static final String DATE_FIELD = "date";
    public static final String MULTILINGUAL_FIELD = "multilingual";
    public static final String SECURITY_POLICY_FIELD = "policy";
    public static final String PERMISSIONS_FIELD = "grantPermission";
    public static final String SELF_URL_FIELD = "selfURL";
    public static final String STRING_ARRAY_FIELD = "stringArray";
    public static final String STRING_FIELD = "string";
    public static final String INT_FIELD = "int";
    public static final String TENANT_FIELD = "tenant";
    public static final String DEFAULT_LOCALE_FIELD = "default";
    public static final String HIGHLIGHTING_FIELD = "highlighting";
    private static final String CM_ID = "cm";
    private static final Map<String, String> CM_QUERY_FIELDS = new HashMap<String, String>();
    private static final Map<String, String> MO_QUERY_FIELDS;
    private static final Set<String> FLATTENED_PERMISSIONS;
    private static final Map<String, Map<String, String>> INDEX_FIELDS_MAP;

    private SearchFieldUtils() {
    }

    public static String getSearchFieldType(String indexId, String fieldName) {
        return SearchFieldUtils.getFieldsMap(indexId).get(fieldName);
    }

    public static boolean isAncestorsField(String indexId, String fieldName) {
        return ANCESTORS_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isContentField(String indexId, String fieldName) {
        return CONTENT_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isContributedField(String indexId, String fieldName) {
        return CONTRIBUTED_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isDateField(String indexId, String fieldName) {
        return DATE_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isIntField(String indexId, String fieldName) {
        return INT_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isMultilingualField(String indexId, String fieldName) {
        return MULTILINGUAL_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isSecurityField(String indexId, String fieldName) {
        return SECURITY_POLICY_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isPermissionsField(String indexId, String fieldName) {
        return PERMISSIONS_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isSelfUrlField(String indexId, String fieldName) {
        return SELF_URL_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isStringArrayField(String indexId, String fieldName) {
        return STRING_ARRAY_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isStringField(String indexId, String fieldName) {
        return STRING_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isTenantField(String indexId, String fieldName) {
        return TENANT_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    public static boolean isDefaultLocaleField(String indexId, String fieldName) {
        return DEFAULT_LOCALE_FIELD.equals(SearchFieldUtils.getFieldsMap(indexId).get(fieldName));
    }

    private static boolean isParentIdField(String fieldName) {
        return FieldNames.PARENT_ID.toString().equals(fieldName);
    }

    private static boolean isHighlightingField(String fieldName) {
        return HIGHLIGHTING_FIELD.equals(fieldName);
    }

    public static Set<String> getPhraseSearchableFields(String indexId) {
        Set<String> fields = SearchFieldUtils.getFieldsMap(indexId).keySet();
        return fields.stream().filter(field -> SearchFieldUtils.isPhraseSearchableField(indexId, field)).collect(Collectors.toSet());
    }

    private static boolean isPhraseSearchableField(String indexId, String fieldName) {
        return SearchFieldUtils.isSearchableField(indexId, fieldName) && !SearchFieldUtils.isNameOrDescription(fieldName);
    }

    private static boolean isNameOrDescription(String fieldName) {
        return FieldNames.NAME.toString().equals(fieldName) || FieldNames.NAME_PARTIAL.toString().equals(fieldName) || FieldNames.DESCRIPTION.toString().equals(fieldName) || FieldNames.DESCRIPTION_PARTIAL.toString().equals(fieldName);
    }

    public static Set<String> getSearchableFields(String indexId) {
        Set<String> fields = SearchFieldUtils.getFieldsMap(indexId).keySet();
        return fields.stream().filter(field -> SearchFieldUtils.isSearchableField(indexId, field)).collect(Collectors.toSet());
    }

    private static boolean isSearchableField(String indexId, String fieldName) {
        return !SearchFieldUtils.isContributedField(indexId, fieldName) && !SearchFieldUtils.isSecurityField(indexId, fieldName) && !SearchFieldUtils.isPermissionsField(indexId, fieldName) && !SearchFieldUtils.isTenantField(indexId, fieldName) && !SearchFieldUtils.isParentIdField(fieldName) && !SearchFieldUtils.isHighlightingField(fieldName) && !FieldNames.TYPE.toString().equals(fieldName) && !FieldNames.SCORE.toString().equals(fieldName);
    }

    public static Set<String> getReturnableFields(String indexId) {
        Set<String> fields = SearchFieldUtils.getFieldsMap(indexId).keySet();
        return fields.stream().filter(field -> SearchFieldUtils.isReturnableField(indexId, field)).collect(Collectors.toSet());
    }

    private static boolean isReturnableField(String indexId, String fieldName) {
        return !SearchFieldUtils.isContributedField(indexId, fieldName) && !SearchFieldUtils.isSecurityField(indexId, fieldName) && !SearchFieldUtils.isAlternativeNameField(fieldName) && !SearchFieldUtils.isPartialMatchField(fieldName);
    }

    private static boolean isAlternativeNameField(String fieldName) {
        return FieldNames.NAME_EXACT.toString().equals(fieldName) || FieldNames.NAME_PARTIAL.toString().equals(fieldName) || FieldNames.NAME_WHITESPACE.toString().equals(fieldName);
    }

    private static boolean isPartialMatchField(String fieldName) {
        return fieldName != null && fieldName.matches("(.*)_partial");
    }

    private static Map<String, String> getFieldsMap(String indexId) {
        if (INDEX_FIELDS_MAP.containsKey(indexId)) {
            return INDEX_FIELDS_MAP.get(indexId);
        }
        throw new SearchException(SearchMessageKeys.UNKNOWN_INDEX, indexId);
    }

    public static boolean isFlattenedPermissionsField(String name) {
        return FLATTENED_PERMISSIONS.contains(name);
    }

    static {
        CM_QUERY_FIELDS.put("id", STRING_FIELD);
        CM_QUERY_FIELDS.put("cmid", INT_FIELD);
        CM_QUERY_FIELDS.put("type", STRING_FIELD);
        CM_QUERY_FIELDS.put("selfUrl", SELF_URL_FIELD);
        CM_QUERY_FIELDS.put("name", MULTILINGUAL_FIELD);
        CM_QUERY_FIELDS.put("description", MULTILINGUAL_FIELD);
        CM_QUERY_FIELDS.put("permissions", PERMISSIONS_FIELD);
        CM_QUERY_FIELDS.put("read", SECURITY_POLICY_FIELD);
        CM_QUERY_FIELDS.put("write", SECURITY_POLICY_FIELD);
        CM_QUERY_FIELDS.put("execute", SECURITY_POLICY_FIELD);
        CM_QUERY_FIELDS.put("setPolicy", SECURITY_POLICY_FIELD);
        CM_QUERY_FIELDS.put("traverse", SECURITY_POLICY_FIELD);
        CM_QUERY_FIELDS.put("modificationTime", DATE_FIELD);
        CM_QUERY_FIELDS.put("owner", STRING_FIELD);
        CM_QUERY_FIELDS.put("tenantID", TENANT_FIELD);
        CM_QUERY_FIELDS.put(ANCESTORS_FIELD, ANCESTORS_FIELD);
        CM_QUERY_FIELDS.put(PARENT_ID_FIELD, PARENT_ID_FIELD);
        CM_QUERY_FIELDS.put("combinedContent", CONTENT_FIELD);
        CM_QUERY_FIELDS.put(CONTENT_FIELD, CONTENT_FIELD);
        CM_QUERY_FIELDS.put("hidden", STRING_FIELD);
        CM_QUERY_FIELDS.put("disabled", STRING_FIELD);
        CM_QUERY_FIELDS.put("credential", STRING_FIELD);
        CM_QUERY_FIELDS.put("active", STRING_FIELD);
        CM_QUERY_FIELDS.put("priority", STRING_FIELD);
        CM_QUERY_FIELDS.put("requestedExecutionTime", DATE_FIELD);
        CM_QUERY_FIELDS.put("dispatcherID", STRING_FIELD);
        CM_QUERY_FIELDS.put("status", STRING_FIELD);
        CM_QUERY_FIELDS.put("user", STRING_FIELD);
        CM_QUERY_FIELDS.put("history", STRING_ARRAY_FIELD);
        CM_QUERY_FIELDS.put("snapShotEnabled", STRING_FIELD);
        CM_QUERY_FIELDS.put("references", STRING_ARRAY_FIELD);
        CM_QUERY_FIELDS.put("iconURI", STRING_FIELD);
        CM_QUERY_FIELDS.put("defaultScreenTip", STRING_FIELD);
        CM_QUERY_FIELDS.put("routingHints", STRING_ARRAY_FIELD);
        CM_QUERY_FIELDS.put("externalReferences", STRING_ARRAY_FIELD);
        CM_QUERY_FIELDS.put("tags", STRING_ARRAY_FIELD);
        CM_QUERY_FIELDS.put("documentID", STRING_FIELD);
        CM_QUERY_FIELDS.put("documentType", STRING_FIELD);
        CM_QUERY_FIELDS.put("defaultName", DEFAULT_LOCALE_FIELD);
        CM_QUERY_FIELDS.put("defaultDescription", DEFAULT_LOCALE_FIELD);
        CM_QUERY_FIELDS.put("is_internal", CONTRIBUTED_FIELD);
        CM_QUERY_FIELDS.put("user_visibility", CONTRIBUTED_FIELD);
        CM_QUERY_FIELDS.put("suggest_tags", CONTRIBUTED_FIELD);
        CM_QUERY_FIELDS.put("virtualParent", STRING_FIELD);
        CM_QUERY_FIELDS.put("creationTime", DATE_FIELD);
        CM_QUERY_FIELDS.put("version", STRING_FIELD);
        CM_QUERY_FIELDS.put("name_exact", STRING_ARRAY_FIELD);
        CM_QUERY_FIELDS.put("name_partial", STRING_ARRAY_FIELD);
        CM_QUERY_FIELDS.put("description_partial", STRING_ARRAY_FIELD);
        CM_QUERY_FIELDS.put("name_whitespace", STRING_ARRAY_FIELD);
        CM_QUERY_FIELDS.put("score", STRING_FIELD);
        CM_QUERY_FIELDS.put(HIGHLIGHTING_FIELD, HIGHLIGHTING_FIELD);
        MO_QUERY_FIELDS = new HashMap<String, String>();
        MO_QUERY_FIELDS.put("id", STRING_FIELD);
        MO_QUERY_FIELDS.put("cmid", STRING_FIELD);
        MO_QUERY_FIELDS.put("parentcmid", STRING_FIELD);
        MO_QUERY_FIELDS.put("name", STRING_FIELD);
        MO_QUERY_FIELDS.put("type", STRING_FIELD);
        MO_QUERY_FIELDS.put("path", STRING_FIELD);
        MO_QUERY_FIELDS.put("Usage", STRING_FIELD);
        MO_QUERY_FIELDS.put("Concept", STRING_FIELD);
        MO_QUERY_FIELDS.put("CoveredText", STRING_FIELD);
        MO_QUERY_FIELDS.put("KeyType", STRING_FIELD);
        MO_QUERY_FIELDS.put("Statistics", STRING_FIELD);
        MO_QUERY_FIELDS.put("DataType", STRING_FIELD);
        MO_QUERY_FIELDS.put("DefaultAggregateType", STRING_FIELD);
        MO_QUERY_FIELDS.put("permissions", SECURITY_POLICY_FIELD);
        MO_QUERY_FIELDS.put("tenantID", TENANT_FIELD);
        MO_QUERY_FIELDS.put("owner", STRING_FIELD);
        MO_QUERY_FIELDS.put("is_internal", CONTRIBUTED_FIELD);
        MO_QUERY_FIELDS.put("user_visibility", CONTRIBUTED_FIELD);
        FLATTENED_PERMISSIONS = new HashSet<String>();
        FLATTENED_PERMISSIONS.add(FieldNames.READ_GRANT.toString());
        FLATTENED_PERMISSIONS.add(FieldNames.READ_DENY.toString());
        FLATTENED_PERMISSIONS.add(FieldNames.WRITE_GRANT.toString());
        FLATTENED_PERMISSIONS.add(FieldNames.WRITE_DENY.toString());
        FLATTENED_PERMISSIONS.add(FieldNames.EXECUTE_GRANT.toString());
        FLATTENED_PERMISSIONS.add(FieldNames.EXECUTE_DENY.toString());
        FLATTENED_PERMISSIONS.add(FieldNames.SETPOLICY_GRANT.toString());
        FLATTENED_PERMISSIONS.add(FieldNames.SETPOLICY_DENY.toString());
        FLATTENED_PERMISSIONS.add(FieldNames.TRAVERSE_GRANT.toString());
        FLATTENED_PERMISSIONS.add(FieldNames.TRAVERSE_DENY.toString());
        INDEX_FIELDS_MAP = new HashMap<String, Map<String, String>>();
        INDEX_FIELDS_MAP.put(CM_ID, CM_QUERY_FIELDS);
    }
}

