/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.search.constants.ObjectTypes;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SearchUtils {
    private static final String QUOTE_CHARACTER = "\"";

    private SearchUtils() {
    }

    public static boolean isPhraseQuery(String queryTerm) {
        return StringUtils.isNotEmpty((String)queryTerm) && queryTerm.length() > 1 && queryTerm.startsWith(QUOTE_CHARACTER) && queryTerm.endsWith(QUOTE_CHARACTER);
    }

    public static boolean isParentTypeOfOutput(String type) {
        return ObjectTypes.ANALYSIS.toString().equals(type) || ObjectTypes.QUERY.toString().equals(type) || ObjectTypes.REPORT.toString().equals(type) || ObjectTypes.INTERACTIVE_REPORT.toString().equals(type) || ObjectTypes.REPORT_TEMPLATE.toString().equals(type);
    }

    public static String escapeSolrKeywords(String queryTerm) {
        queryTerm = queryTerm.replaceAll("[+\\-!(){}\\[\\]^~*?:/\\\\|&]", "\\\\$0");
        return queryTerm.replaceAll("\\b(AND|OR|NOT)\\b", "\\\\$1");
    }

    public static boolean listContainsAny(JsonArray listToCheck, List<String> values) {
        if (values != null && listToCheck != null) {
            for (String value : values) {
                if (!listToCheck.contains((Object)value)) continue;
                return true;
            }
        }
        return false;
    }
}

