/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.search.util;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import com.ibm.bi.platform.commons.crypto.internal.session.TrustedRequestSession;
import com.ibm.bi.search.common.SearchException;
import java.lang.invoke.MethodHandles;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustTokenAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TrustedRequestSession trs;

    public TrustTokenAuthenticator() {
        try {
            this.trs = JCAMCrypto.createTrustedRequestSession();
        }
        catch (CAMCryptoException e) {
            throw SearchException.wrap((Exception)((Object)e), 401, "CAM Crypto failed to create trusted request session.", new Object[0]);
        }
    }

    protected TrustTokenAuthenticator(TrustedRequestSession trs) {
        this.trs = trs;
    }

    public boolean isTrustTokenValid(String trustToken) {
        try {
            if (StringUtils.isNotEmpty((String)trustToken) && this.trs.verifyToken(trustToken)) {
                return true;
            }
        }
        catch (CAMCryptoException e) {
            LOG.error("The trust token could not be verified by CAM Service.", (Throwable)e);
        }
        return false;
    }
}

