/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.IntValue;

public class IntField
extends AnalyticsField
implements IntValue.CastingIntValue {
    private NumericDocValues docValues;
    private int value;
    private boolean exists;

    public IntField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getNumeric((LeafReader)context.reader(), (String)this.fieldName);
    }

    @Override
    public void collect(int doc) throws IOException {
        this.exists = this.docValues.advanceExact(doc);
        if (this.exists) {
            this.value = (int)this.docValues.longValue();
        }
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.exists ? Integer.toString(this.value) : null;
    }

    @Override
    public Object getObject() {
        return this.exists ? Integer.valueOf(this.value) : null;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void streamInts(IntConsumer cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public void streamFloats(FloatConsumer cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        if (this.exists) {
            cons.accept(Integer.toString(this.value));
        }
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public ExpressionComparator<Integer> getObjectComparator(String expression) {
        return new ExpressionComparator<Integer>(expression);
    }
}

