/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.pkcs.DecryptionResult;
import com.cognos.accman.jcam.crypto.pkcs.EncryptionResult;
import com.cognos.accman.jcam.crypto.pkcs.PKCS7EncryptedData;
import com.cognos.accman.res.MessageSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

class CAMCipherStreamFactory {
    private static final byte[] STREAM_HEADER = new byte[]{67, 69, 83, 72};
    private static final byte STREAM_VERSION = 1;

    CAMCipherStreamFactory() {
    }

    static CipherInputStream CreateCipherInputStream(String fileName) throws CAMCryptoException, FileNotFoundException {
        File file = new File(fileName);
        DataInputStream is = new DataInputStream(new FileInputStream(file));
        byte[] headerMagic = new byte[STREAM_HEADER.length];
        byte[] pkcs7Data = null;
        try {
            is.readFully(headerMagic);
            if (!Arrays.equals(headerMagic, STREAM_HEADER)) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
            }
            byte version = is.readByte();
            if (version != 1) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
            }
            int pkcs7DataSize = is.readInt();
            if (pkcs7DataSize > 10240) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
            }
            pkcs7Data = new byte[pkcs7DataSize];
            is.readFully(pkcs7Data);
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
        }
        DecryptionResult result = PKCS7EncryptedData.getDecryptionResult(pkcs7Data);
        Cipher c = result.getCipher();
        CipherInputStream cis = new CipherInputStream(is, c);
        return cis;
    }

    static CipherOutputStream CreateCipherOutputStream(String fileName) throws CAMCryptoException, FileNotFoundException {
        File file = new File(fileName);
        DataOutputStream os = new DataOutputStream(new FileOutputStream(file));
        EncryptionResult encryptionResult = PKCS7EncryptedData.getEncryptionResult(KeyStoreReader.getCSKWithExpiryCheck(), STREAM_HEADER);
        try {
            os.write(STREAM_HEADER);
            os.writeByte(1);
            os.writeInt(encryptionResult.getEncryptedData().length);
            os.write(encryptionResult.getEncryptedData());
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        Cipher c = encryptionResult.getCipher();
        CipherOutputStream cos = new CipherOutputStream(os, c);
        return cos;
    }
}

