/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.contentclient;

import com.ibm.bi.admin.commons.contentclient.ClientService;
import com.ibm.bi.admin.commons.exception.AdminException;
import com.ibm.bi.admin.commons.json.JsonEngine;
import com.ibm.bi.admin.commons.json.JsonEngineFactory;
import com.ibm.bi.admin.commons.utilities.AdminUtil;
import com.ibm.bi.admin.commons.utilities.EndpointProperty;
import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.ContentManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapBridgeClient
implements ClientService {
    public static final String STOREID_PATTERN = "(i[A-Z0-9]{32}|xO[a-zA-Z0-9]+_)";
    private static Pattern ID_PATTERN = Pattern.compile("(i[A-Z0-9]{32}|xO[a-zA-Z0-9]+_)");
    private static final Logger logger = LoggerFactory.getLogger(SoapBridgeClient.class);
    private int ADMIN_SOAP_REQUEST_TIMEOUT = 30000;
    protected JsonEngine jsonEngine = JsonEngineFactory.getDefaultEngine();
    protected HttpServletResponse response;
    protected static final List<String> ALLPROPERTIES = new ArrayList<String>(Arrays.asList("objectClass", "*"));
    private BiBus biBus = null;

    protected boolean isStoreID(String id) {
        return ID_PATTERN.matcher(id).matches();
    }

    protected JsonEngine getJsonEngine() {
        return this.jsonEngine;
    }

    public SoapBridgeClient(BiBus bibus) {
        this.biBus = bibus;
    }

    @Override
    @Deprecated
    public String get(String searchPath) {
        String calSearchPath = this.getSearchPath(searchPath);
        String retJson = null;
        try {
            JsonArray result = (JsonArray)this.getContentManager().query(calSearchPath, ALLPROPERTIES, null, null);
            retJson = AdminUtil.queryResultWrapper(this.getJsonEngine().toJson(result));
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        return retJson;
    }

    public String getSearchPath(String searchPathorID) {
        return AdminUtil.formatSearchPath(searchPathorID);
    }

    @Override
    public String post(String content, String pathOrStoreid) {
        String calSearchPath = null;
        calSearchPath = this.getSearchPath(pathOrStoreid);
        JsonObject options = new JsonObject();
        options.put("ignoreInvalidObjectReference", (Object)"false");
        options.put("updateAction", (Object)"fail");
        ArrayList<String> retPros = new ArrayList<String>();
        retPros.add("storeID");
        options.put("returnProperties", retPros);
        StringReader reader = new StringReader(content);
        List ret = null;
        try {
            Object object = new JsonParser(DefaultJsonFactory.instance).parse((Reader)reader);
            ArrayList<Object> objects = new ArrayList<Object>();
            objects.add(object);
            ret = this.getContentManager().add(calSearchPath, objects, (Map)options);
            JsonObject result = this.wrapResult(ret);
            return this.getJsonEngine().toJson(result);
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
    }

    public ContentManager getContentManager() {
        return this.biBus.contentManager;
    }

    private JsonObject wrapResult(List ret) {
        JsonObject result = (JsonObject)ret.get(0);
        if (result.containsKey((Object)"id")) {
            result.put("status", (Object)Response.Status.OK.getStatusCode());
        } else {
            result.put("status", (Object)Response.Status.GONE.getStatusCode());
        }
        return result;
    }

    @Override
    public String delete(String pathorstoreID) {
        String searchPathFromId = this.getSearchPath(pathorstoreID);
        return this.doCmDelete(searchPathFromId);
    }

    @Override
    public String deleteBySearchPath(String searchPath) {
        return this.doCmDelete(searchPath);
    }

    private String doCmDelete(String searchPath) {
        ArrayList<String> objects = new ArrayList<String>();
        objects.add(searchPath);
        Map ret = DefaultJsonFactory.instance.createObject();
        Map options = DefaultJsonFactory.instance.createObject();
        options.put("force", "true");
        options.put("recursive", "true");
        try {
            long number = (Long)this.getContentManager().delete(objects, options);
            if (number >= 1L) {
                ret.put("status", Response.Status.OK.getStatusCode());
            } else {
                ret.put("status", Response.Status.NOT_FOUND.getStatusCode());
            }
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        return this.getJsonEngine().toJson(ret);
    }

    @Override
    public void head(Map<String, String> params) {
    }

    @Override
    public String put(String content, String pathOrID) {
        String calSearchPath = null;
        calSearchPath = this.getSearchPath(pathOrID);
        ArrayList<Object> objects = new ArrayList<Object>();
        List ret = null;
        try {
            JSONObject jsonContent = new JSONObject(content);
            jsonContent.put("searchPath", (Object)calSearchPath);
            StringReader reader = new StringReader(jsonContent.toString());
            Object object = new JsonParser(DefaultJsonFactory.instance).parse((Reader)reader);
            Map options = DefaultJsonFactory.instance.createObject();
            options.put("updateTenantIDRecursive", false);
            objects.add(object);
            ret = (List)this.getContentManager().update(objects, options);
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        return this.getJsonEngine().toJson(this.wrapResult(ret));
    }

    protected static String getSearchPathFromId(String id) {
        StringBuilder buf = new StringBuilder(64);
        buf.append("storeID(\"").append(id).append("\")");
        return buf.toString();
    }

    @Override
    public String queryObjects(String searchPath, int skipObjects, int maxObjects) {
        String calSearchPath = this.getSearchPath(searchPath);
        Map options = DefaultJsonFactory.instance.createObject();
        options.put("maxObjects", maxObjects);
        options.put("skipObjects", skipObjects);
        String retJson = null;
        try {
            JsonArray result = (JsonArray)this.getContentManager().query(calSearchPath, ALLPROPERTIES, null, options);
            retJson = AdminUtil.queryResultWrapper(this.getJsonEngine().toJson(result));
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        return retJson;
    }

    @Override
    public String queryObjectWithOptions(String searchPath, List properties, List sortBy, Map options, EndpointProperty endpointProperty) {
        return this.queryObjectWithOptions(searchPath, properties, sortBy, options, this.ADMIN_SOAP_REQUEST_TIMEOUT, endpointProperty);
    }

    @Override
    public String queryObjectWithOptions(String searchPath, List properties, List sortBy, Map options, int requestTimeout, EndpointProperty endpointProperty) {
        String retJson = null;
        try {
            JsonArray result = (JsonArray)this.getContentManager().query(searchPath, properties, sortBy, options, requestTimeout);
            if (endpointProperty != null && endpointProperty.getMethodType() != null && endpointProperty.getPath() != null) {
                String ResourceName = endpointProperty.getMethodType() + "_" + endpointProperty.getPath();
                logger.debug("\n\n***ADMIN-ACCOUNT-SERVICE-LOGGING::CM RESPONSE FOR: " + ResourceName + " \n " + result.toString() + " \n ***END OF LOG\n\n");
            }
            retJson = AdminUtil.queryResultWrapper(this.getJsonEngine().toJson(result));
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        return retJson;
    }

    @Override
    public String listArchives() {
        String retJson = null;
        JsonArray jsArray = new JsonArray();
        try {
            JsonArray result = (JsonArray)this.getContentManager().listArchives();
            for (int i = 0; i < result.size(); ++i) {
                JsonObject jsObj = new JsonObject();
                jsObj.put("name", (Object)((String)result.get(i)));
                jsArray.add((Object)jsObj);
            }
            JsonObject jsObject = new JsonObject();
            jsObject.put("data", (Object)jsArray);
            retJson = jsObject.toString();
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        return retJson;
    }
}

