/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.exception;

import com.ibm.bi.admin.commons.exception.AdminException;
import com.ibm.bi.admin.commons.utilities.AdminLogger;
import com.ibm.bi.admin.commons.utilities.AdminLoggerFactory;
import com.ibm.bi.soap.services.SoapException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class AdminExceptionMapper
implements ExceptionMapper<Exception> {
    @Context
    protected HttpServletRequest request;
    private static final AdminLogger logger = AdminLoggerFactory.getLogger(AdminExceptionMapper.class);

    public Response toResponse(Exception cause) {
        Response response = null;
        if (cause instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)cause;
            response = wae.getResponse();
        } else {
            response = cause instanceof SoapException ? this.constructSoapExceptionResponse((SoapException)cause) : (cause instanceof AdminException ? this.constructAdminExceptionResponse((AdminException)((Object)cause)) : this.constructAdminExceptionResponse(new AdminException(cause)));
        }
        logger.error(cause.getMessage(), cause);
        return response;
    }

    private Response constructAdminExceptionResponse(AdminException e) {
        return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity(e.getResponseEntity(this.request.getLocale())).type("application/json").build();
    }

    private Response constructSoapExceptionResponse(SoapException e) {
        return Response.status((int)e.getStatusCode()).entity(e.getErrorDetails()).type("application/json").build();
    }
}

