/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.utilities;

import com.ibm.bi.admin.commons.exception.AdminException;
import com.ibm.bi.admin.commons.utilities.AdminLogger;
import com.ibm.bi.admin.commons.utilities.AdminLoggerFactory;
import com.ibm.bi.json.JsonArray;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class AdminUtil {
    public static final String STOREID_PATTERN = "(i[A-Z0-9]{32}|xO[a-zA-Z0-9]+_)";
    private static Pattern ID_PATTERN = Pattern.compile("(i[A-Z0-9]{32}|xO[a-zA-Z0-9]+_)");
    public static final String ROLE_STOREID_PATTERN = "(x.*_)";
    private static Pattern ROLE_ID_PATTERN = Pattern.compile("(x.*_)");
    public static final String ACCOUNT_STOREID_PATTERN = "(x.*)";
    private static Pattern ACCOUNT_ID_PATTERN = Pattern.compile("(x.*)");
    private static final AdminLogger logger = AdminLoggerFactory.getLogger(AdminUtil.class);

    public static boolean isStoreID(String id) {
        return ID_PATTERN.matcher(id).matches() || ROLE_ID_PATTERN.matcher(id).matches() || ACCOUNT_ID_PATTERN.matcher(id).matches();
    }

    public static String buildLocationURI(List result) {
        String uri = "";
        try {
            JsonArray data = (JsonArray)result;
            uri = (String)data.getObject(0).getObject("_meta").getObject("links").getObject("self").get("url");
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
        }
        return uri;
    }

    public static String getSearchPathFromId(String id) {
        if (AdminUtil.isStoreID(id)) {
            StringBuilder buf = new StringBuilder();
            buf.append("storeID(\"").append(id).append("\")");
            return buf.toString();
        }
        return id;
    }

    public static byte[] readFromStream(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1000];
        int wasRead = 0;
        do {
            if ((wasRead = stream.read(buffer)) <= 0) continue;
            baos.write(buffer, 0, wasRead);
        } while (wasRead > -1);
        return baos.toByteArray();
    }

    public static String getUtf8StringFromBytes(byte[] content) throws UnsupportedEncodingException {
        return new String(content, "UTF-8");
    }

    public static String queryResultWrapper(String object) {
        JSONObject wrapper = new JSONObject();
        try {
            JSONObject queryResult = new JSONObject();
            if (AdminUtil.isJsonArray(object)) {
                JSONArray arrayObjects = new JSONArray(object);
                queryResult.put("item", (Collection)arrayObjects);
            } else {
                JSONObject objectJson = null;
                objectJson = new JSONObject(object);
                queryResult.put("item", (Map)objectJson);
            }
            wrapper.put("queryResult", (Map)queryResult);
        }
        catch (JSONException e) {
            throw new AdminException(e);
        }
        return wrapper.toString();
    }

    private static boolean isJsonArray(String json) {
        String jsonStr = json.trim();
        return jsonStr.startsWith("[");
    }

    public static String formatSearchPath(String path) {
        String[] pathSections = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (String section : pathSections) {
            String temp = null;
            temp = AdminUtil.isStoreID(section) ? AdminUtil.getSearchPathFromId(section) : section;
            sb.append(temp).append("/");
        }
        String calPath = sb.toString();
        return calPath.substring(0, calPath.length() - 1);
    }

    public static List<String> calRequiredFields(Class<?> clazz, List<String> IgnoreFields) {
        ArrayList<String> fields = new ArrayList<String>();
        if (IgnoreFields == null) {
            IgnoreFields = new ArrayList<String>();
        }
        try {
            PropertyDescriptor[] descriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor propery : descriptors = beanInfo.getPropertyDescriptors()) {
                if (IgnoreFields.contains(propery.getName())) continue;
                fields.add(propery.getName());
            }
        }
        catch (IntrospectionException e) {
            logger.error(e.getMessage(), e);
            fields.add("*");
        }
        return fields;
    }
}

