/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tunnel.tcp;

import com.ibm.bi.crypto.tunnel.TunnelException;
import com.ibm.bi.crypto.tunnel.utils.Jsse;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SocketsFactory {
    public static Socket sslSocket(String hostname, int port, X509Certificate ... trustedCerts) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{Jsse.trustManagerFromCertificates(trustedCerts)}, new SecureRandom());
            return sslContext.getSocketFactory().createSocket(hostname, port);
        }
        catch (Exception e) {
            throw new TunnelException("could not create ssl socket", e);
        }
    }

    public static Socket sslSocket(String hostname, int port, PrivateKey privateKey, X509Certificate[] certChain, X509Certificate[] trustedCerts) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            KeyManager[] keyManager = null;
            if (privateKey != null && certChain != null) {
                keyManager = new KeyManager[]{Jsse.keyManager(privateKey, certChain)};
            }
            TrustManager[] trustManager = null;
            if (trustedCerts != null) {
                trustManager = new TrustManager[]{Jsse.trustManagerFromCertificates(trustedCerts)};
            }
            sslContext.init(keyManager, trustManager, new SecureRandom());
            return sslContext.getSocketFactory().createSocket(hostname, port);
        }
        catch (Exception e) {
            throw new TunnelException("could not create ssl socket", e);
        }
    }
}

