/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tunnel.tcp;

import com.ibm.bi.crypto.tunnel.Config;
import com.ibm.bi.crypto.tunnel.TunnelException;
import com.ibm.bi.crypto.tunnel.tcp.ConnectionTerminationHandler;
import com.ibm.bi.crypto.tunnel.tcp.TcpForwarder;
import com.ibm.bi.crypto.tunnel.tcp.TcpObserver;
import com.ibm.bi.crypto.tunnel.tcp.TcpTunnelConnectionEventsListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTunnelConnection
implements ConnectionTerminationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTunnelConnection.class);
    private final Socket localSocket;
    private final Socket remoteSocket;
    private final AtomicInteger halfTerminationsCount;
    private TcpTrafficCounter inboundTcpTrafficCounter;
    private TcpTrafficCounter outboundTcpTrafficCounter;
    private Object closeLock = new Object();
    private TcpTunnelConnectionEventsListener tcpTunnelConnectionEventsListener;

    public TcpTunnelConnection(Socket localSocket, Socket remoteSocket, TcpTunnelConnectionEventsListener tcpTunnelConnectionEventsListener, ExecutorService sessionExecutorService) {
        Objects.requireNonNull(localSocket, "local socket should not be null");
        Objects.requireNonNull(remoteSocket, "remote socket should not be null");
        Objects.requireNonNull(sessionExecutorService, "session executor service is needed to run tcp traffic forwarders");
        try {
            this.halfTerminationsCount = new AtomicInteger();
            this.localSocket = localSocket;
            this.remoteSocket = remoteSocket;
            this.localSocket.setKeepAlive(true);
            this.remoteSocket.setKeepAlive(true);
            this.tcpTunnelConnectionEventsListener = tcpTunnelConnectionEventsListener;
            InputStream localIn = localSocket.getInputStream();
            OutputStream localOut = localSocket.getOutputStream();
            InputStream remoteIn = remoteSocket.getInputStream();
            OutputStream remoteOut = remoteSocket.getOutputStream();
            this.outboundTcpTrafficCounter = new TcpTrafficCounter();
            TcpForwarder localForward = new TcpForwarder(localSocket + "->" + remoteSocket, localIn, remoteOut, this, Config.tcpTunnelConnectionBufferSize, this.outboundTcpTrafficCounter);
            sessionExecutorService.submit(localForward);
            this.inboundTcpTrafficCounter = new TcpTrafficCounter();
            TcpForwarder remoteForward = new TcpForwarder(remoteSocket + "->" + localSocket, remoteIn, localOut, this, Config.tcpTunnelConnectionBufferSize, this.inboundTcpTrafficCounter);
            sessionExecutorService.submit(remoteForward);
        }
        catch (Exception e) {
            throw new TunnelException("could not create tunnel connection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.localSocket.isClosed() && this.remoteSocket.isClosed();
        }
    }

    public long inboundTrafficBytesCount() {
        return this.inboundTcpTrafficCounter.processedBytesCount;
    }

    public long ouboundTrafficBytesCount() {
        return this.outboundTcpTrafficCounter.processedBytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateConnection() {
        LOG.info("THREAD {}: TCP tunnel connection {} is being terminated", (Object)Thread.currentThread().getName(), (Object)this);
        try {
            Object object = this.closeLock;
            synchronized (object) {
                if (!this.localSocket.isClosed()) {
                    this.localSocket.close();
                }
                if (!this.remoteSocket.isClosed()) {
                    this.remoteSocket.close();
                }
            }
        }
        catch (Exception e) {
            throw new TunnelException("could not terminate connection", e);
        }
        this.tcpTunnelConnectionEventsListener.onConnectionClose(this);
    }

    @Override
    public void terminateHalfConnection() {
        int eofs = this.halfTerminationsCount.incrementAndGet();
        if (eofs == 2) {
            this.terminateConnection();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TcpTunnelConnection rhs = (TcpTunnelConnection)obj;
        return new EqualsBuilder().append((Object)this.localSocket, (Object)rhs.localSocket).append((Object)this.remoteSocket, (Object)rhs.remoteSocket).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.localSocket).append((Object)this.remoteSocket).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("localSocket", (Object)this.localSocket).append("remoteSocket", (Object)this.remoteSocket).append("inbound", this.inboundTrafficBytesCount()).append("outbound", this.ouboundTrafficBytesCount()).toString();
    }

    private static class TcpTrafficCounter
    implements TcpObserver {
        private long processedBytesCount = 0L;

        private TcpTrafficCounter() {
        }

        @Override
        public void observe(byte[] buffer, int start, int count) throws IOException {
            this.processedBytesCount += (long)count;
        }
    }
}

