/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tunnel.utils;

import com.ibm.bi.crypto.tunnel.utils.CommonsException;
import org.slf4j.helpers.MessageFormatter;

public enum ErrorCode {
    COULD_NOT_ENCRYPT_CONTENT(1, "encryption error"),
    COULD_NOT_DECRYPT_CONTENT(2, "decryption error"),
    HASH_GENERATION_ERROR(3, "hash generation error"),
    SECRET_KEY_GENERATION_ERROR(4, "Secret key generation error"),
    KEY_PAIR_GENERATION_ERROR(5, "key pair generation error"),
    PRIVATE_KEY_GENERATION_ERROR(6, "private key generation error"),
    CERTIFICATE_GENERATION_ERROR(7, "certificate generation error"),
    SERIALIZATION_ERROR(8, "serialization error"),
    RETRY_TIMEOUT_ERROR(9, "retrying timed out without successful outcome"),
    MAX_RETRY_ERROR(10, "retrying reached max without successful outcome"),
    COMPRESSION_ERROR(11, "could not compress or decompress data"),
    CERTIFICATE_SIGNATURE_ERROR(12, "could not sign certificate"),
    CSR_GENERATION_ERROR(13, "could not generate csr"),
    PEM_CERT_GENERATION_ERROR(14, "could not generating certificate pem"),
    COULD_NOT_GET_EXTRACT_COMMON_NAME(15, "could not extract common name from certificate"),
    COULD_NOT_JOIN_SECRET_PIECES(16, "could not join secret pieces"),
    COULD_NOT_JOIN_SECRET_PIECES_MIN_UNMET(17, "could not join secret pieces given that we don't have enough pieces"),
    COULD_NOT_SPLIT_SECRET_INTO_PIECES(18, "could not split secret into pieces"),
    COULD_NOT_JOIN_SECRET_PIECES_INCOHERENT_PIECES(19, "could not join secret pieces given that they are not derived from same secret"),
    COULD_NOT_JOIN_SECRET_PIECES_UNDECODABLE_PIECE(20, "could not join secret pieces given that we cannot decode piece {}"),
    COULD_NOT_MASK_STRING(21, "could not mask string"),
    COULD_NOT_DECOMPOSE_URI_QUERY(22, "could not decompose URI query into key value pairs");

    public final int code;
    public final String msg;

    private ErrorCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public CommonsException exception(Object ... args) {
        return new CommonsException(this, MessageFormatter.arrayFormat((String)this.msg, (Object[])args).getMessage());
    }

    public CommonsException exception(Throwable cause, Object ... msgArgs) {
        return new CommonsException(this, MessageFormatter.arrayFormat((String)this.msg, (Object[])msgArgs).getMessage(), cause);
    }
}

