/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.gss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

class SSPIMessage {
    private static final int MESSAGE_MAGIC = 1128353089;
    private final Vector<byte[]> subMessages = new Vector(1);

    SSPIMessage() {
    }

    public void addSubMessage(byte[] message) {
        byte[] subMessage = new byte[message.length];
        System.arraycopy(message, 0, subMessage, 0, message.length);
        this.subMessages.add(subMessage);
    }

    public int getSubMessageCount() {
        return this.subMessages.size();
    }

    public byte[] getSubMessage(int index) {
        return this.subMessages.elementAt(index);
    }

    public int FromBlob(byte[] blob, int offset) throws IOException {
        int skipedBytes;
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(blob, offset, blob.length - offset));
        int magic = is.readInt();
        int size = is.readInt();
        int subCount = is.readInt();
        int extraHeaderSize = is.readInt() - 16;
        if (extraHeaderSize > 0 && (skipedBytes = is.skipBytes(extraHeaderSize)) != extraHeaderSize) {
            throw new IOException("skipBytes returned " + skipedBytes + " instead of " + extraHeaderSize);
        }
        if (magic != 1128353089) {
            throw new IOException("invalid packet. m=" + magic + " instead of " + 1128353089);
        }
        this.subMessages.clear();
        for (int i = 0; i < subCount; ++i) {
            int size1 = is.readInt();
            byte[] subMessage = new byte[size1];
            is.readFully(subMessage);
            this.subMessages.add(subMessage);
        }
        return size;
    }

    public byte[] ToBlob() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        int blobSize = 0;
        for (byte[] subMessage : this.subMessages) {
            blobSize += 4 + subMessage.length;
        }
        os.writeByte(2);
        os.writeInt(1128353089);
        os.writeInt(blobSize += 16);
        os.writeInt(this.subMessages.size());
        os.writeInt(16);
        for (byte[] subMessage : this.subMessages) {
            os.writeInt(subMessage.length);
            os.write(subMessage);
        }
        byte[] blob = baos.toByteArray();
        return blob;
    }
}

