/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.IJVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;

public class CAMCertSHA2Verifier {
    private final HashSet<String> allowedCertSigAlgs = new HashSet();

    public CAMCertSHA2Verifier() throws CAMCryptoException {
        this(JVMEnvironment.getInstance());
    }

    public CAMCertSHA2Verifier(IJVMEnvironment jvmEnv) {
        this.allowedCertSigAlgs.add("1.2.840.113549.1.1.11");
        this.allowedCertSigAlgs.add("1.2.840.113549.1.1.12");
        this.allowedCertSigAlgs.add("1.2.840.113549.1.1.13");
        this.allowedCertSigAlgs.add("1.2.840.113549.1.1.14");
        this.allowedCertSigAlgs.add("2.16.840.1.101.3.4.3.1");
        this.allowedCertSigAlgs.add("2.16.840.1.101.3.4.3.2");
        this.allowedCertSigAlgs.add("1.2.840.10045.4.3.1");
        this.allowedCertSigAlgs.add("1.2.840.10045.4.3.2");
        this.allowedCertSigAlgs.add("1.2.840.10045.4.3.3");
        this.allowedCertSigAlgs.add("1.2.840.10045.4.3.4");
        if (!jvmEnv.OnlyUseSHA_2()) {
            this.allowedCertSigAlgs.add("1.2.840.113549.1.1.5");
            this.allowedCertSigAlgs.add("1.2.840.10040.4.3");
            this.allowedCertSigAlgs.add("1.2.840.10045.4.1");
        }
    }

    public void verifyCerts(CertPath certPath) throws CertPathValidatorException {
        for (X509Certificate x509Certificate : certPath.getCertificates()) {
            this.isCertSHA2(x509Certificate);
        }
    }

    public void verifyCerts(Set trustAnchors) throws CertPathValidatorException {
        for (TrustAnchor ancohor : trustAnchors) {
            X509Certificate cert = ancohor.getTrustedCert();
            this.isCertSHA2(cert);
        }
    }

    private void isCertSHA2(X509Certificate cert) throws CertPathValidatorException {
        if (!this.isSupportedSignatureAlg(cert)) {
            throw new CertPathValidatorException("Not signed with SHA-2");
        }
    }

    public boolean isSupportedSignatureAlg(X509Certificate cert) {
        return this.allowedCertSigAlgs.contains(cert.getSigAlgOID());
    }
}

