/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapperException;
import com.cognos.accman.jcam.crypto.misc.PemGenerator;
import com.cognos.accman.res.MessageSet;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;

class CSRGenerator {
    public static final String DER_FORMAT = "der";
    public static final String PEM_FORMAT = "pem";

    CSRGenerator() {
    }

    public static byte[] generateCSR(String subject, PublicKey pubKey, PrivateKey signingKey) throws CAMCryptoException {
        byte[] pkcs10data;
        Configuration config = Configuration.getInstance();
        try {
            String shaAlg = config.getDigestAlgorithm();
            pkcs10data = CryptoWrapper.createCertificateRequest(subject, pubKey, signingKey, shaAlg, null);
        }
        catch (CryptoWrapperException cwe) {
            throw new CAMCryptoException(cwe, MessageSet.getMessage("CAM_CRP_generic_no_make_CSR"));
        }
        return pkcs10data;
    }

    public static byte[] generateCSR(String subject, PublicKey pubKey, PrivateKey signingKey, String format) throws CAMCryptoException {
        byte[] b = CSRGenerator.generateCSR(subject, pubKey, signingKey);
        if (format == DER_FORMAT) {
            return b;
        }
        if (format == PEM_FORMAT) {
            return PemGenerator.encode(b, "NEW CERTIFICATE REQUEST");
        }
        throw new CAMCryptoException("Invalid format for csr.  Must be pem or der.");
    }

    public static void generateCSR(String subject, PublicKey pubKey, PrivateKey signingKey, String format, String location) throws CAMCryptoException {
        String generalMessage = "Generating a CSR was not successful. ";
        byte[] b = CSRGenerator.generateCSR(subject, pubKey, signingKey, format);
        try {
            String filename = format == DER_FORMAT ? location + "cert_der.csr" : location + "cert_pem.csr";
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(b);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, generalMessage + "IO problems. ");
        }
    }
}

